/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.MultisearchSearchRequestExecutor;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.SearchSearchRequestAssembler;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.SearchSearchResponseAssembler;
import com.liferay.portal.search.engine.adapter.search.MultisearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.MultisearchSearchResponse;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={MultisearchSearchRequestExecutor.class})
public class MultisearchSearchRequestExecutorImpl
implements MultisearchSearchRequestExecutor {
    private static final Log _log = LogFactoryUtil.getLog(MultisearchSearchRequestExecutorImpl.class);
    @Reference
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    @Reference
    private SearchSearchRequestAssembler _searchSearchRequestAssembler;
    @Reference
    private SearchSearchResponseAssembler _searchSearchResponseAssembler;

    @Override
    public MultisearchSearchResponse execute(MultisearchSearchRequest multisearchSearchRequest) {
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        List searchSearchRequests = multisearchSearchRequest.getSearchSearchRequests();
        ArrayList searchRequestHolders = new ArrayList(searchSearchRequests.size());
        searchSearchRequests.forEach(searchSearchRequest -> {
            SearchRequest searchRequest = new SearchRequest(searchSearchRequest.getIndexNames());
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            this._searchSearchRequestAssembler.assemble(searchSourceBuilder, (SearchSearchRequest)searchSearchRequest, searchRequest);
            SearchRequestHolder searchRequestHolder = new SearchRequestHolder((SearchSearchRequest)searchSearchRequest, searchSourceBuilder);
            searchRequestHolders.add(searchRequestHolder);
            multiSearchRequest.add(searchRequest);
        });
        MultiSearchResponse multiSearchResponse = this._getMultiSearchResponse(multiSearchRequest, multisearchSearchRequest);
        Iterator iterator = multiSearchResponse.iterator();
        MultisearchSearchResponse multisearchSearchResponse = new MultisearchSearchResponse();
        int counter = 0;
        while (iterator.hasNext()) {
            MultiSearchResponse.Item multiSearchResponseItem = (MultiSearchResponse.Item)iterator.next();
            SearchResponse searchResponse = multiSearchResponseItem.getResponse();
            SearchSearchResponse searchSearchResponse = new SearchSearchResponse();
            SearchRequestHolder searchRequestHolder = (SearchRequestHolder)searchRequestHolders.get(counter);
            SearchSearchRequest searchSearchRequest2 = searchRequestHolder.getSearchSearchRequest();
            this._searchSearchResponseAssembler.assemble(searchRequestHolder.getSearchSourceBuilder(), searchResponse, searchSearchRequest2, searchSearchResponse);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"The search engine processed ", searchSearchResponse.getSearchRequestString(), " in ", searchSearchResponse.getExecutionTime(), " ms"}));
            }
            if (searchSearchRequest2.isIncludeResponseString()) {
                searchSearchResponse.setSearchResponseString(searchResponse.toString());
            }
            ++counter;
        }
        return multisearchSearchResponse;
    }

    private MultiSearchResponse _getMultiSearchResponse(MultiSearchRequest multiSearchRequest, MultisearchSearchRequest multisearchSearchRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(multisearchSearchRequest.getConnectionId(), multisearchSearchRequest.isPreferLocalCluster());
        try {
            return restHighLevelClient.msearch(multiSearchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private class SearchRequestHolder {
        private final SearchSearchRequest _searchSearchRequest;
        private final SearchSourceBuilder _searchSourceBuilder;

        public SearchRequestHolder(SearchSearchRequest searchSearchRequest, SearchSourceBuilder searchSourceBuilder) {
            this._searchSearchRequest = searchSearchRequest;
            this._searchSourceBuilder = searchSourceBuilder;
        }

        public SearchSearchRequest getSearchSearchRequest() {
            return this._searchSearchRequest;
        }

        public SearchSourceBuilder getSearchSourceBuilder() {
            return this._searchSourceBuilder;
        }
    }
}

