/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index;

import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.IndicesExistsIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.IndicesExistsIndexRequest;
import com.liferay.portal.search.engine.adapter.index.IndicesExistsIndexResponse;
import java.io.IOException;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={IndicesExistsIndexRequestExecutor.class})
public class IndicesExistsIndexRequestExecutorImpl
implements IndicesExistsIndexRequestExecutor {
    @Reference
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public IndicesExistsIndexResponse execute(IndicesExistsIndexRequest indicesExistsIndexRequest) {
        return new IndicesExistsIndexResponse(this._indicesExists(this.createGetIndexRequest(indicesExistsIndexRequest), indicesExistsIndexRequest));
    }

    protected GetIndexRequest createGetIndexRequest(IndicesExistsIndexRequest indicesExistsIndexRequest) {
        GetIndexRequest getIndexRequest = new GetIndexRequest();
        getIndexRequest.indices(indicesExistsIndexRequest.getIndexNames());
        return getIndexRequest;
    }

    private boolean _indicesExists(GetIndexRequest getIndexRequest, IndicesExistsIndexRequest indicesExistsIndexRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(indicesExistsIndexRequest.getConnectionId(), indicesExistsIndexRequest.isPreferLocalCluster());
        IndicesClient indicesClient = restHighLevelClient.indices();
        try {
            return indicesClient.exists(getIndexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

