/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index;

import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.CloseIndexRequestExecutor;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.IndicesOptionsTranslator;
import com.liferay.portal.search.engine.adapter.index.CloseIndexRequest;
import com.liferay.portal.search.engine.adapter.index.CloseIndexResponse;
import com.liferay.portal.search.engine.adapter.index.IndicesOptions;
import java.io.IOException;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.core.TimeValue;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CloseIndexRequestExecutor.class})
public class CloseIndexRequestExecutorImpl
implements CloseIndexRequestExecutor {
    @Reference
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    @Reference
    private IndicesOptionsTranslator _indicesOptionsTranslator;

    @Override
    public CloseIndexResponse execute(CloseIndexRequest closeIndexRequest) {
        org.elasticsearch.client.indices.CloseIndexRequest elasticsearchCloseIndexRequest = this.createCloseIndexRequest(closeIndexRequest);
        AcknowledgedResponse acknowledgedResponse = this.getAcknowledgedResponse(elasticsearchCloseIndexRequest, closeIndexRequest);
        return new CloseIndexResponse(acknowledgedResponse.isAcknowledged());
    }

    protected org.elasticsearch.client.indices.CloseIndexRequest createCloseIndexRequest(CloseIndexRequest closeIndexRequest) {
        org.elasticsearch.client.indices.CloseIndexRequest elasticsearchCloseIndexRequest = new org.elasticsearch.client.indices.CloseIndexRequest(closeIndexRequest.getIndexNames());
        IndicesOptions indicesOptions = closeIndexRequest.getIndicesOptions();
        if (indicesOptions != null) {
            elasticsearchCloseIndexRequest.indicesOptions(this._indicesOptionsTranslator.translate(indicesOptions));
        }
        if (closeIndexRequest.getTimeout() > 0L) {
            TimeValue timeValue = TimeValue.timeValueMillis((long)closeIndexRequest.getTimeout());
            elasticsearchCloseIndexRequest.setMasterTimeout(timeValue);
            elasticsearchCloseIndexRequest.setTimeout(timeValue);
        }
        return elasticsearchCloseIndexRequest;
    }

    protected AcknowledgedResponse getAcknowledgedResponse(org.elasticsearch.client.indices.CloseIndexRequest elasticsearchCloseIndexRequest, CloseIndexRequest closeIndexRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(closeIndexRequest.getConnectionId(), closeIndexRequest.isPreferLocalCluster());
        IndicesClient indicesClient = restHighLevelClient.indices();
        try {
            return indicesClient.close(elasticsearchCloseIndexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

