/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.script.ScriptTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document.UpdateByQueryDocumentRequestExecutor;
import com.liferay.portal.search.engine.adapter.document.UpdateByQueryDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateByQueryDocumentResponse;
import com.liferay.portal.search.query.QueryTranslator;
import com.liferay.portal.search.script.ScriptBuilder;
import com.liferay.portal.search.script.ScriptType;
import com.liferay.portal.search.script.Scripts;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={UpdateByQueryDocumentRequestExecutor.class})
public class UpdateByQueryDocumentRequestExecutorImpl
implements UpdateByQueryDocumentRequestExecutor {
    @Reference
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    @Reference(target="(search.engine.impl=Elasticsearch)")
    private com.liferay.portal.kernel.search.query.QueryTranslator<QueryBuilder> _legacyQueryTranslator;
    @Reference(target="(search.engine.impl=Elasticsearch)")
    private QueryTranslator<QueryBuilder> _queryTranslator;
    @Reference
    private Scripts _scripts;
    private final ScriptTranslator _scriptTranslator = new ScriptTranslator();

    @Override
    public UpdateByQueryDocumentResponse execute(UpdateByQueryDocumentRequest updateByQueryDocumentRequest) {
        UpdateByQueryRequest updateByQueryRequest = this.createUpdateByQueryRequest(updateByQueryDocumentRequest);
        BulkByScrollResponse bulkByScrollResponse = this.getBulkByScrollResponse(updateByQueryRequest, updateByQueryDocumentRequest);
        TimeValue timeValue = bulkByScrollResponse.getTook();
        return new UpdateByQueryDocumentResponse(bulkByScrollResponse.getUpdated(), timeValue.getMillis());
    }

    protected UpdateByQueryRequest createUpdateByQueryRequest(UpdateByQueryDocumentRequest updateByQueryDocumentRequest) {
        QueryBuilder queryBuilder;
        UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest();
        updateByQueryRequest.indices(updateByQueryDocumentRequest.getIndexNames());
        if (updateByQueryDocumentRequest.getPortalSearchQuery() != null) {
            queryBuilder = (QueryBuilder)this._queryTranslator.translate(updateByQueryDocumentRequest.getPortalSearchQuery());
            updateByQueryRequest.setQuery(queryBuilder);
        } else {
            queryBuilder = (QueryBuilder)this._legacyQueryTranslator.translate(updateByQueryDocumentRequest.getQuery(), null);
            updateByQueryRequest.setQuery(queryBuilder);
        }
        updateByQueryRequest.setRefresh(updateByQueryDocumentRequest.isRefresh());
        if (updateByQueryDocumentRequest.getScript() != null) {
            updateByQueryRequest.setScript(this._scriptTranslator.translate(updateByQueryDocumentRequest.getScript()));
        } else if (updateByQueryDocumentRequest.getScriptJSONObject() != null) {
            ScriptBuilder scriptBuilder = this._scripts.builder();
            JSONObject scriptJSONObject = updateByQueryDocumentRequest.getScriptJSONObject();
            if (scriptJSONObject.has("idOrCode")) {
                scriptBuilder.idOrCode(scriptJSONObject.getString("idOrCode"));
            }
            if (scriptJSONObject.has("language")) {
                scriptBuilder.language(scriptJSONObject.getString("language"));
            }
            if (scriptJSONObject.has("optionsMap")) {
                scriptBuilder.options((Map)scriptJSONObject.get("optionsMap"));
            }
            if (scriptJSONObject.has("parametersMap")) {
                scriptBuilder.parameters((Map)scriptJSONObject.get("parametersMap"));
            }
            if (scriptJSONObject.has("scriptType")) {
                scriptBuilder.scriptType((ScriptType)scriptJSONObject.get("scriptType"));
            }
            updateByQueryRequest.setScript(this._scriptTranslator.translate(scriptBuilder.build()));
        }
        return updateByQueryRequest;
    }

    protected BulkByScrollResponse getBulkByScrollResponse(UpdateByQueryRequest updateByQueryRequest, UpdateByQueryDocumentRequest updateByQueryDocumentRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(updateByQueryDocumentRequest.getConnectionId(), updateByQueryDocumentRequest.isPreferLocalCluster());
        try {
            return restHighLevelClient.updateByQuery(updateByQueryRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

