/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.cluster;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.cluster.ClusterHealthStatusTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.cluster.StatsClusterRequestExecutor;
import com.liferay.portal.search.engine.adapter.cluster.ClusterHealthStatus;
import com.liferay.portal.search.engine.adapter.cluster.StatsClusterRequest;
import com.liferay.portal.search.engine.adapter.cluster.StatsClusterResponse;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StatsClusterRequestExecutor.class})
public class StatsClusterRequestExecutorImpl
implements StatsClusterRequestExecutor {
    @Reference
    private ClusterHealthStatusTranslator _clusterHealthStatusTranslator;
    @Reference
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    @Reference
    private JSONFactory _jsonFactory;

    @Override
    public StatsClusterResponse execute(StatsClusterRequest statsClusterRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(statsClusterRequest.getConnectionId(), statsClusterRequest.isPreferLocalCluster());
        RestClient restClient = restHighLevelClient.getLowLevelClient();
        String nodeIds = "";
        if (ArrayUtil.isNotEmpty((Object[])statsClusterRequest.getNodeIds())) {
            nodeIds = "/nodes/" + StringUtil.merge((Object[])statsClusterRequest.getNodeIds());
        }
        String endpoint = "/_cluster/stats" + nodeIds;
        Request request = new Request("GET", endpoint);
        try {
            Response response = restClient.performRequest(request);
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject responseJSONObject = this._jsonFactory.createJSONObject(responseBody);
            String status = GetterUtil.getString((Object)responseJSONObject.get("status"));
            ClusterHealthStatus clusterHealthStatus = null;
            if (!status.equals("")) {
                clusterHealthStatus = this._clusterHealthStatusTranslator.translate(status);
            }
            return new StatsClusterResponse(clusterHealthStatus, responseBody);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

