/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.cluster;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.cluster.StateClusterRequestExecutor;
import com.liferay.portal.search.engine.adapter.cluster.StateClusterRequest;
import com.liferay.portal.search.engine.adapter.cluster.StateClusterResponse;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StateClusterRequestExecutor.class})
public class StateClusterRequestExecutorImpl
implements StateClusterRequestExecutor {
    @Reference
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public StateClusterResponse execute(StateClusterRequest stateClusterRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(stateClusterRequest.getConnectionId(), stateClusterRequest.isPreferLocalCluster());
        RestClient restClient = restHighLevelClient.getLowLevelClient();
        String endpoint = "/_cluster/state";
        Request request = new Request("GET", endpoint);
        try {
            Response response = restClient.performRequest(request);
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            return new StateClusterResponse(responseBody);
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }
}

