/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.filter;

import com.liferay.portal.kernel.search.filter.GeoDistanceRangeFilter;
import com.liferay.portal.kernel.search.geolocation.GeoDistance;
import com.liferay.portal.kernel.search.geolocation.GeoLocationPoint;
import com.liferay.portal.search.elasticsearch7.internal.filter.GeoDistanceRangeFilterTranslator;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.query.GeoDistanceQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.osgi.service.component.annotations.Component;

@Component(service={GeoDistanceRangeFilterTranslator.class})
public class GeoDistanceRangeFilterTranslatorImpl
implements GeoDistanceRangeFilterTranslator {
    @Override
    public QueryBuilder translate(GeoDistanceRangeFilter geoDistanceRangeFilter) {
        GeoDistanceQueryBuilder geoDistanceQueryBuilder = new GeoDistanceQueryBuilder(geoDistanceRangeFilter.getField());
        GeoDistance geoDistance = geoDistanceRangeFilter.getUpperBoundGeoDistance();
        geoDistanceQueryBuilder.distance(String.valueOf(geoDistance.getDistance()), DistanceUnit.fromString((String)String.valueOf(geoDistance.getDistanceUnit())));
        GeoLocationPoint geoLocationPoint = geoDistanceRangeFilter.getPinGeoLocationPoint();
        geoDistanceQueryBuilder.point(new GeoPoint(geoLocationPoint.getLatitude(), geoLocationPoint.getLongitude()));
        return geoDistanceQueryBuilder;
    }
}

