/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.facet;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.search.facet.util.RangeParserUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetProcessor;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetUtil;
import java.util.List;
import java.util.Optional;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import org.osgi.service.component.annotations.Component;

@Component(property={"class.name=com.liferay.portal.kernel.search.facet.RangeFacet"}, service={FacetProcessor.class})
public class RangeFacetProcessor
implements FacetProcessor<SearchRequestBuilder> {
    @Override
    public Optional<AggregationBuilder> processFacet(Facet facet) {
        FacetConfiguration facetConfiguration = facet.getFacetConfiguration();
        RangeAggregationBuilder rangeAggregationBuilder = AggregationBuilders.range((String)FacetUtil.getAggregationName(facet));
        rangeAggregationBuilder.field(facetConfiguration.getFieldName());
        this._addConfigurationRanges(facetConfiguration, rangeAggregationBuilder);
        this._addCustomRange(facet, rangeAggregationBuilder);
        if (ListUtil.isEmpty((List)rangeAggregationBuilder.ranges())) {
            return Optional.empty();
        }
        return Optional.of(rangeAggregationBuilder);
    }

    private void _addConfigurationRanges(FacetConfiguration facetConfiguration, RangeAggregationBuilder rangeAggregationBuilder) {
        JSONObject jsonObject = facetConfiguration.getData();
        JSONArray jsonArray = jsonObject.getJSONArray("ranges");
        if (jsonArray == null) {
            return;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject rangeJSONObject = jsonArray.getJSONObject(i);
            String rangeString = rangeJSONObject.getString("range");
            String[] range = RangeParserUtil.parserRange((String)rangeString);
            rangeAggregationBuilder.addRange(this._createRange(rangeString, range));
        }
    }

    private void _addCustomRange(Facet facet, RangeAggregationBuilder rangeAggregationBuilder) {
        SearchContext searchContext = facet.getSearchContext();
        String rangeString = GetterUtil.getString((Object)searchContext.getAttribute(facet.getFieldId()));
        if (Validator.isNull((String)rangeString)) {
            return;
        }
        String[] range = RangeParserUtil.parserRange((String)rangeString);
        rangeAggregationBuilder.addRange(this._createRange(rangeString, range));
    }

    private RangeAggregator.Range _createRange(String key, String[] range) {
        return new RangeAggregator.Range(key, range[0], range[1]);
    }
}

