/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.facet;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetProcessor;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetUtil;
import com.liferay.portal.search.facet.nested.NestedFacet;
import java.util.Optional;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.nested.NestedAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.osgi.service.component.annotations.Component;

@Component(property={"class.name=com.liferay.portal.search.internal.facet.NestedFacetImpl"}, service={FacetProcessor.class})
public class NestedFacetProcessor
implements FacetProcessor<SearchRequestBuilder> {
    @Override
    public Optional<AggregationBuilder> processFacet(Facet facet) {
        int size;
        if (!(facet instanceof NestedFacet)) {
            return Optional.empty();
        }
        NestedFacet nestedFacet = (NestedFacet)facet;
        FacetConfiguration facetConfiguration = facet.getFacetConfiguration();
        JSONObject dataJSONObject = facetConfiguration.getData();
        TermsAggregationBuilder termsAggregationBuilder = AggregationBuilders.terms((String)FacetUtil.getAggregationName(facet));
        termsAggregationBuilder.field(nestedFacet.getFieldName());
        int minDocCount = dataJSONObject.getInt("frequencyThreshold");
        if (minDocCount > 0) {
            termsAggregationBuilder.minDocCount((long)minDocCount);
        }
        if ((size = dataJSONObject.getInt("maxTerms")) > 0) {
            termsAggregationBuilder.size(size);
        }
        TermsAggregationBuilder aggregationBuilder = termsAggregationBuilder;
        if (Validator.isNotNull((String)nestedFacet.getFilterField())) {
            TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)nestedFacet.getFilterField(), (String)nestedFacet.getFilterValue());
            FilterAggregationBuilder filterAggregationBuilder = AggregationBuilders.filter((String)FacetUtil.getAggregationName(facet), (QueryBuilder)termQueryBuilder);
            filterAggregationBuilder.subAggregation((AggregationBuilder)termsAggregationBuilder);
            aggregationBuilder = filterAggregationBuilder;
        }
        NestedAggregationBuilder nestedAggregationBuilder = AggregationBuilders.nested((String)FacetUtil.getAggregationName(facet), (String)nestedFacet.getPath());
        nestedAggregationBuilder.subAggregation((AggregationBuilder)aggregationBuilder);
        return Optional.of(nestedAggregationBuilder);
    }
}

