/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.document;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.geolocation.GeoLocationPoint;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.document.ElasticsearchDocumentFactory;
import com.liferay.portal.search.elasticsearch7.internal.geolocation.GeoLocationPointTranslator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang.time.FastDateFormat;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.osgi.service.component.annotations.Component;

@Component(service={ElasticsearchDocumentFactory.class})
public class DefaultElasticsearchDocumentFactory
implements ElasticsearchDocumentFactory {
    public static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyyMMddHHmmss");
    public static final String DATE_MAX_VALUE = "99950812133000";

    @Override
    @Deprecated
    public String getElasticsearchDocument(Document legacyDocument) {
        try {
            return Strings.toString((XContentBuilder)this.translate(legacyDocument));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public XContentBuilder getElasticsearchDocument(com.liferay.portal.search.document.Document document) {
        try {
            return this.translate(document);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected XContentBuilder translate(Document legacyDocument) throws IOException {
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
        xContentBuilder.startObject();
        Map fields = legacyDocument.getFields();
        this._addFields(fields.values(), xContentBuilder);
        xContentBuilder.endObject();
        return xContentBuilder;
    }

    protected XContentBuilder translate(com.liferay.portal.search.document.Document document) throws IOException {
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
        Map fields = document.getFields();
        xContentBuilder.startObject();
        for (com.liferay.portal.search.document.Field field : fields.values()) {
            this._addField(field, xContentBuilder);
        }
        xContentBuilder.endObject();
        return xContentBuilder;
    }

    private void _addDates(XContentBuilder xContentBuilder, Field field) throws IOException {
        for (Date date : field.getDates()) {
            String value = date.getTime() == Long.MAX_VALUE ? DATE_MAX_VALUE : DATE_FORMAT.format(date);
            xContentBuilder.value(value);
        }
    }

    private void _addField(com.liferay.portal.search.document.Field field, XContentBuilder xContentBuilder) throws IOException {
        List values = field.getValues();
        if (values.isEmpty()) {
            this._addFieldValueless(field, xContentBuilder);
        }
        if (values.size() == 1) {
            this._addFieldValue(field, values.get(0), xContentBuilder);
            return;
        }
        this._addFieldValues(field, values, xContentBuilder);
    }

    private void _addField(XContentBuilder xContentBuilder, Field field) throws IOException {
        String name = field.getName();
        if (!field.isLocalized()) {
            Object[] values = field.getValues();
            if (ArrayUtil.isEmpty((Object[])values)) {
                return;
            }
            ArrayList<String> valuesList = new ArrayList<String>(values.length);
            for (Object value : values) {
                if (value == null) continue;
                valuesList.add(((String)value).trim());
            }
            if (valuesList.isEmpty()) {
                return;
            }
            values = valuesList.toArray(new String[0]);
            this._addField(xContentBuilder, field, name, (String[])values);
            if (field.isSortable()) {
                this._addField(xContentBuilder, field, this._getSortableFieldName(name), (String[])values);
            }
        } else {
            Map localizedValues = field.getLocalizedValues();
            for (Map.Entry entry : localizedValues.entrySet()) {
                String value = (String)entry.getValue();
                if (Validator.isNull((String)value)) continue;
                Locale locale = (Locale)entry.getKey();
                String languageId = LocaleUtil.toLanguageId((Locale)locale);
                String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
                value = value.trim();
                if (languageId.equals(defaultLanguageId)) {
                    this._addField(xContentBuilder, field, name, value);
                }
                String localizedName = Field.getLocalizedName((String)languageId, (String)name);
                this._addField(xContentBuilder, field, localizedName, value);
                if (!field.isSortable()) continue;
                this._addField(xContentBuilder, field, this._getSortableFieldName(localizedName), value);
            }
        }
    }

    private void _addField(XContentBuilder xContentBuilder, Field field, String fieldName, String ... values) throws IOException {
        GeoLocationPoint geoLocationPoint;
        xContentBuilder.field(fieldName);
        if (field.isArray() || values.length > 1) {
            xContentBuilder.startArray();
        }
        if ((geoLocationPoint = field.getGeoLocationPoint()) != null) {
            GeoPoint geoPoint = new GeoPoint(geoLocationPoint.getLatitude(), geoLocationPoint.getLongitude());
            xContentBuilder.value((Object)geoPoint);
        } else if (field.isDate()) {
            this._addDates(xContentBuilder, field);
        } else {
            for (String value : values) {
                xContentBuilder.value(this._translateValue(field, value));
            }
        }
        if (field.isArray() || values.length > 1) {
            xContentBuilder.endArray();
        }
    }

    private void _addFields(Collection<Field> fields, XContentBuilder xContentBuilder) throws IOException {
        for (Field field : fields) {
            if (!field.hasChildren()) {
                this._addField(xContentBuilder, field);
                continue;
            }
            this._addNestedField(xContentBuilder, field);
        }
    }

    private void _addFieldValue(com.liferay.portal.search.document.Field field, Object value, XContentBuilder xContentBuilder) throws IOException {
        xContentBuilder.field(field.getName(), this._toElasticsearchValue(value));
    }

    private void _addFieldValueless(com.liferay.portal.search.document.Field field, XContentBuilder xContentBuilder) throws IOException {
        xContentBuilder.field(field.getName());
    }

    private void _addFieldValues(com.liferay.portal.search.document.Field field, List<Object> values, XContentBuilder xContentBuilder) throws IOException {
        Stream stream = values.stream();
        xContentBuilder.array(field.getName(), stream.map(this::_toElasticsearchValue).toArray());
    }

    private void _addNestedField(XContentBuilder xContentBuilder, Field field) throws IOException {
        if (field.isArray()) {
            xContentBuilder.startArray(field.getName());
        } else if (Validator.isNull((String)field.getName())) {
            xContentBuilder.startObject();
        } else {
            xContentBuilder.startObject(field.getName());
        }
        this._addFields(field.getFields(), xContentBuilder);
        if (field.isArray()) {
            xContentBuilder.endArray();
        } else {
            xContentBuilder.endObject();
        }
    }

    private String _getSortableFieldName(String localizedName) {
        return Field.getSortableFieldName((String)localizedName);
    }

    private Object _toElasticsearchValue(Object value) {
        if (value instanceof com.liferay.portal.search.geolocation.GeoLocationPoint) {
            return GeoLocationPointTranslator.translate((com.liferay.portal.search.geolocation.GeoLocationPoint)value);
        }
        return value;
    }

    private Object _translateValue(Field field, String value) {
        if (!field.isNumeric()) {
            return value;
        }
        Class clazz = field.getNumericClass();
        if (clazz.equals(Float.class)) {
            return Float.valueOf(value);
        }
        if (clazz.equals(Integer.class)) {
            return Integer.valueOf(value);
        }
        if (clazz.equals(Long.class)) {
            return Long.valueOf(value);
        }
        if (clazz.equals(Short.class)) {
            return Short.valueOf(value);
        }
        return Double.valueOf(value);
    }
}

