/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.connection;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.ccr.CrossClusterReplicationConfigurationHelper;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationObserver;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationWrapper;
import com.liferay.portal.search.elasticsearch7.internal.configuration.OperationModeResolver;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnection;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnectionBuilder;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnectionNotInitializedException;
import com.liferay.portal.search.elasticsearch7.internal.connection.ProxyConfig;
import com.liferay.portal.search.elasticsearch7.internal.helper.SearchLogHelperUtil;
import java.net.InetAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.elasticsearch.client.RestHighLevelClient;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={ElasticsearchClientResolver.class, ElasticsearchConnectionManager.class})
public class ElasticsearchConnectionManager
implements ElasticsearchClientResolver,
ElasticsearchConfigurationObserver {
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected volatile CrossClusterReplicationConfigurationHelper crossClusterReplicationConfigurationHelper;
    @Reference
    protected volatile ElasticsearchConfigurationWrapper elasticsearchConfigurationWrapper;
    @Reference
    protected Http http;
    @Reference
    protected OperationModeResolver operationModeResolver;
    private static final Log _log = LogFactoryUtil.getLog(ElasticsearchConnectionManager.class);
    @Reference
    private ClusterExecutor _clusterExecutor;
    private final Map<String, ElasticsearchConnection> _elasticsearchConnections = new ConcurrentHashMap<String, ElasticsearchConnection>();

    public void addElasticsearchConnection(ElasticsearchConnection elasticsearchConnection) {
        String connectionId = elasticsearchConnection.getConnectionId();
        if (connectionId == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Skipping connection because connection ID is null");
            }
            return;
        }
        if (elasticsearchConnection.isActive()) {
            try {
                elasticsearchConnection.connect();
            }
            catch (RuntimeException runtimeException) {
                if (connectionId.equals("__SIDECAR__")) {
                    _log.error((Object)StringBundler.concat((String[])new String[]{"Elasticsearch sidecar could not be started. ", "Search will be unavailable. Manual installation ", "of Elasticsearch and activation of remote mode ", "is recommended."}), (Throwable)runtimeException);
                }
                throw runtimeException;
            }
        }
        this._elasticsearchConnections.put(connectionId, elasticsearchConnection);
    }

    @Override
    public int compareTo(ElasticsearchConfigurationObserver elasticsearchConfigurationObserver) {
        return this.elasticsearchConfigurationWrapper.compare(this, elasticsearchConfigurationObserver);
    }

    public ElasticsearchConnection getElasticsearchConnection() {
        return this.getElasticsearchConnection(null, false);
    }

    public ElasticsearchConnection getElasticsearchConnection(boolean preferLocalCluster) {
        return this.getElasticsearchConnection(null, preferLocalCluster);
    }

    public ElasticsearchConnection getElasticsearchConnection(String connectionId) {
        ElasticsearchConnection elasticsearchConnection = this._elasticsearchConnections.get(connectionId);
        if (_log.isInfoEnabled()) {
            if (elasticsearchConnection != null) {
                _log.info((Object)("Returning connection with ID: " + connectionId));
            } else {
                _log.info((Object)("Connection not found. Returning null for ID: " + connectionId));
            }
        }
        return elasticsearchConnection;
    }

    public Collection<ElasticsearchConnection> getElasticsearchConnections() {
        return this._elasticsearchConnections.values();
    }

    public String getLocalClusterConnectionId() {
        ClusterNode localClusterNode = this._clusterExecutor.getLocalClusterNode();
        if (localClusterNode == null) {
            List localClusterConnectionIds = this.crossClusterReplicationConfigurationHelper.getLocalClusterConnectionIds();
            return (String)localClusterConnectionIds.get(0);
        }
        InetAddress portalInetAddress = localClusterNode.getPortalInetAddress();
        if (portalInetAddress == null) {
            return null;
        }
        String localClusterNodeHostName = portalInetAddress.getHostName() + ":" + localClusterNode.getPortalPort();
        Map localClusterConnectionConfigurations = this.crossClusterReplicationConfigurationHelper.getLocalClusterConnectionIdsMap();
        return (String)localClusterConnectionConfigurations.get(localClusterNodeHostName);
    }

    @Override
    public int getPriority() {
        return 2;
    }

    @Override
    public RestHighLevelClient getRestHighLevelClient() {
        return this.getRestHighLevelClient(null);
    }

    @Override
    public RestHighLevelClient getRestHighLevelClient(String connectionId) {
        return this.getRestHighLevelClient(connectionId, false);
    }

    @Override
    public RestHighLevelClient getRestHighLevelClient(String connectionId, boolean preferLocalCluster) {
        ElasticsearchConnection elasticsearchConnection = this.getElasticsearchConnection(connectionId, preferLocalCluster);
        if (elasticsearchConnection == null) {
            throw new ElasticsearchConnectionNotInitializedException(this._getExceptionMessage("Elasticsearch connection not found.", connectionId, preferLocalCluster));
        }
        RestHighLevelClient restHighLevelClient = elasticsearchConnection.getRestHighLevelClient();
        if (restHighLevelClient == null) {
            throw new ElasticsearchConnectionNotInitializedException(this._getExceptionMessage("REST high level client not found.", elasticsearchConnection.getConnectionId(), preferLocalCluster));
        }
        return restHighLevelClient;
    }

    public boolean isCrossClusterReplicationEnabled() {
        CrossClusterReplicationConfigurationHelper currentCrossClusterReplicationConfigurationHelper = this.crossClusterReplicationConfigurationHelper;
        if (currentCrossClusterReplicationConfigurationHelper == null) {
            return false;
        }
        return currentCrossClusterReplicationConfigurationHelper.isCrossClusterReplicationEnabled();
    }

    @Override
    public void onElasticsearchConfigurationUpdate() {
        this.applyConfigurations();
    }

    public void removeElasticsearchConnection(String connectionId) {
        if (connectionId == null) {
            return;
        }
        ElasticsearchConnection elasticsearchConnection = this._elasticsearchConnections.get(connectionId);
        if (elasticsearchConnection == null) {
            return;
        }
        elasticsearchConnection.close();
        this._elasticsearchConnections.remove(connectionId);
    }

    @Activate
    protected void activate() {
        this.elasticsearchConfigurationWrapper.register(this);
        this.applyConfigurations();
    }

    protected void applyConfigurations() {
        SearchLogHelperUtil.setRESTClientLoggerLevel(this.elasticsearchConfigurationWrapper.restClientLoggerLevel());
        if (this.operationModeResolver.isProductionModeEnabled()) {
            if (Validator.isBlank((String)this.elasticsearchConfigurationWrapper.remoteClusterConnectionId())) {
                this.addElasticsearchConnection(this._createRemoteElasticsearchConnection());
            }
        } else {
            this.removeElasticsearchConnection("__REMOTE__");
        }
    }

    protected ProxyConfig createProxyConfig() {
        ProxyConfig.Builder proxyConfigBuilder = ProxyConfig.builder(this.http);
        return proxyConfigBuilder.networkAddresses(this.elasticsearchConfigurationWrapper.networkHostAddresses()).host(this.elasticsearchConfigurationWrapper.proxyHost()).password(this.elasticsearchConfigurationWrapper.proxyPassword()).port(this.elasticsearchConfigurationWrapper.proxyPort()).userName(this.elasticsearchConfigurationWrapper.proxyHost()).build();
    }

    @Deactivate
    protected void deactivate() {
        this.elasticsearchConfigurationWrapper.unregister(this);
        Collection<ElasticsearchConnection> elasticsearchConnections = this._elasticsearchConnections.values();
        for (ElasticsearchConnection elasticsearchConnection : elasticsearchConnections) {
            elasticsearchConnection.close();
        }
    }

    protected ElasticsearchConnection getElasticsearchConnection(String connectionId, boolean preferLocalCluster) {
        String localClusterConnectionId;
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Connection requested for ID: " + connectionId));
        }
        if (!Validator.isBlank((String)connectionId)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Getting connection with ID: " + connectionId));
            }
            return this.getElasticsearchConnection(connectionId);
        }
        if (this.operationModeResolver.isDevelopmentModeEnabled()) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Getting __SIDECAR__ connection");
            }
            return this.getElasticsearchConnection("__SIDECAR__");
        }
        if (preferLocalCluster && this.isCrossClusterReplicationEnabled() && (localClusterConnectionId = this.getLocalClusterConnectionId()) != null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Getting local cluster connection with ID: " + localClusterConnectionId));
            }
            return this.getElasticsearchConnection(localClusterConnectionId);
        }
        String remoteClusterConnectionId = this.elasticsearchConfigurationWrapper.remoteClusterConnectionId();
        if (Validator.isBlank((String)remoteClusterConnectionId)) {
            remoteClusterConnectionId = "__REMOTE__";
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Getting remote cluster connection with ID: " + remoteClusterConnectionId));
        }
        return this.getElasticsearchConnection(remoteClusterConnectionId);
    }

    private ElasticsearchConnection _createRemoteElasticsearchConnection() {
        ElasticsearchConnectionBuilder elasticsearchConnectionBuilder = new ElasticsearchConnectionBuilder();
        elasticsearchConnectionBuilder.active(true).authenticationEnabled(this.elasticsearchConfigurationWrapper.authenticationEnabled()).connectionId("__REMOTE__").httpSSLEnabled(this.elasticsearchConfigurationWrapper.httpSSLEnabled()).networkHostAddresses(this.elasticsearchConfigurationWrapper.networkHostAddresses()).password(this.elasticsearchConfigurationWrapper.password()).proxyConfig(this.createProxyConfig()).truststorePassword(this.elasticsearchConfigurationWrapper.truststorePassword()).truststorePath(this.elasticsearchConfigurationWrapper.truststorePath()).truststoreType(this.elasticsearchConfigurationWrapper.truststoreType()).userName(this.elasticsearchConfigurationWrapper.userName());
        return elasticsearchConnectionBuilder.build();
    }

    private String _getExceptionMessage(String message, String connectionId, boolean preferLocalCluster) {
        return StringBundler.concat((Object[])new Object[]{message, " Production Mode Enabled: ", this.operationModeResolver.isProductionModeEnabled(), ", Connection ID: ", connectionId, ", Prefer Local Cluster: ", preferLocalCluster, ", Cross-Cluster Replication Enabled: ", this.isCrossClusterReplicationEnabled(), ". Enable INFO logs on ", ElasticsearchConnectionManager.class, " for more information"});
    }
}

