/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.search.SearchPaginationUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexSearcher;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsImpl;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.suggest.QuerySuggester;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregation;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationWrapper;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.BaseSearchRequest;
import com.liferay.portal.search.engine.adapter.search.BaseSearchResponse;
import com.liferay.portal.search.engine.adapter.search.CountSearchRequest;
import com.liferay.portal.search.engine.adapter.search.CountSearchResponse;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.search.legacy.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.legacy.searcher.SearchResponseBuilderFactory;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchResponseBuilder;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"search.engine.impl=Elasticsearch"}, service={IndexSearcher.class})
public class ElasticsearchIndexSearcher
extends BaseIndexSearcher {
    private static final Log _log = LogFactoryUtil.getLog(ElasticsearchIndexSearcher.class);
    @Reference
    private volatile ElasticsearchConfigurationWrapper _elasticsearchConfigurationWrapper;
    @Reference
    private IndexNameBuilder _indexNameBuilder;
    @Reference
    private Props _props;
    @Reference(target="(search.engine.impl=Elasticsearch)")
    private QuerySuggester _querySuggester;
    @Reference(target="(search.engine.impl=Elasticsearch)")
    private SearchEngineAdapter _searchEngineAdapter;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private SearchResponseBuilderFactory _searchResponseBuilderFactory;

    public String getQueryString(SearchContext searchContext, Query query) {
        return this._searchEngineAdapter.getQueryString(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hits search(SearchContext searchContext, Query query) {
        Hits hits;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            int end = searchContext.getEnd();
            int start = searchContext.getStart();
            SearchRequest searchRequest = this._getSearchRequest(searchContext);
            Integer from = searchRequest.getFrom();
            Integer size = searchRequest.getSize();
            if (from == null && size != null) {
                end = size;
                start = 0;
            } else if (from != null && size != null) {
                end = from + size;
                start = from;
            }
            if (start == -1) {
                start = 0;
            } else if (start < 0) {
                throw new IllegalArgumentException("Invalid start " + start);
            }
            if (end == -1) {
                end = GetterUtil.getInteger((String)this._props.get("index.search.limit"));
            } else if (end < 0) {
                throw new IllegalArgumentException("Invalid end " + end);
            }
            SearchResponseBuilder searchResponseBuilder = this._getSearchResponseBuilder(searchContext);
            Hits hits2 = null;
            while (true) {
                SearchSearchRequest searchSearchRequest = this.createSearchSearchRequest(searchRequest, searchContext, query, start, end);
                SearchSearchResponse searchSearchResponse = (SearchSearchResponse)this._searchEngineAdapter.execute((com.liferay.portal.search.engine.adapter.search.SearchRequest)searchSearchRequest);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"The search engine processed ", searchSearchResponse.getSearchRequestString(), " in ", searchSearchResponse.getExecutionTime(), " ms"}));
                }
                this._populateResponse(searchSearchResponse, searchResponseBuilder);
                searchResponseBuilder.searchHits(searchSearchResponse.getSearchHits());
                hits2 = searchSearchResponse.getHits();
                Document[] documents = hits2.getDocs();
                if (documents.length != 0 || start == 0) break;
                int[] startAndEnd = SearchPaginationUtil.calculateStartAndEnd((int)start, (int)end, (int)hits2.getLength());
                start = startAndEnd[0];
                end = startAndEnd[1];
            }
            hits2.setStart(stopWatch.getStartTime());
            hits = hits2;
        }
        catch (RuntimeException runtimeException) {
            HitsImpl hitsImpl;
            try {
                if (!this.handle(runtimeException)) {
                    if (this._elasticsearchConfigurationWrapper.logExceptionsOnly()) {
                        _log.error((Throwable)runtimeException);
                    } else {
                        throw runtimeException;
                    }
                }
                searchContext.setAttribute("search.exception.message", (Serializable)((Object)this._getExceptionMessage(runtimeException)));
                hitsImpl = new HitsImpl();
            }
            catch (Throwable throwable) {
                if (_log.isInfoEnabled()) {
                    stopWatch.stop();
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching took ", stopWatch.getTime(), " ms"}));
                }
                throw throwable;
            }
            if (_log.isInfoEnabled()) {
                stopWatch.stop();
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching took ", stopWatch.getTime(), " ms"}));
            }
            return hitsImpl;
        }
        if (_log.isInfoEnabled()) {
            stopWatch.stop();
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching took ", stopWatch.getTime(), " ms"}));
        }
        return hits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long searchCount(SearchContext searchContext, Query query) {
        long l;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            CountSearchRequest countSearchRequest = this._createCountSearchRequest(searchContext, query);
            CountSearchResponse countSearchResponse = (CountSearchResponse)this._searchEngineAdapter.execute((com.liferay.portal.search.engine.adapter.search.SearchRequest)countSearchRequest);
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"The search engine processed ", countSearchResponse.getSearchRequestString(), " in ", countSearchResponse.getExecutionTime(), " ms"}));
            }
            this._populateResponse((BaseSearchResponse)countSearchResponse, this._getSearchResponseBuilder(searchContext));
            l = countSearchResponse.getCount();
        }
        catch (RuntimeException runtimeException) {
            long l2;
            try {
                if (!this.handle(runtimeException)) {
                    if (this._elasticsearchConfigurationWrapper.logExceptionsOnly()) {
                        _log.error((Throwable)runtimeException);
                    } else {
                        throw runtimeException;
                    }
                }
                l2 = 0L;
            }
            catch (Throwable throwable) {
                if (_log.isInfoEnabled()) {
                    stopWatch.stop();
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching took ", stopWatch.getTime(), " ms"}));
                }
                throw throwable;
            }
            if (_log.isInfoEnabled()) {
                stopWatch.stop();
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching took ", stopWatch.getTime(), " ms"}));
            }
            return l2;
        }
        if (_log.isInfoEnabled()) {
            stopWatch.stop();
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching took ", stopWatch.getTime(), " ms"}));
        }
        return l;
    }

    protected SearchSearchRequest createSearchSearchRequest(SearchRequest searchRequest, SearchContext searchContext, Query query, int start, int end) {
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        this._prepare((BaseSearchRequest)searchSearchRequest, searchRequest, query, searchContext);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        searchSearchRequest.setAlternateUidFieldName(queryConfig.getAlternateUidFieldName());
        searchSearchRequest.setBasicFacetSelection(searchRequest.isBasicFacetSelection());
        searchSearchRequest.putAllFacets(searchContext.getFacets());
        searchSearchRequest.setFetchSource(searchRequest.getFetchSource());
        searchSearchRequest.setFetchSourceExcludes(searchRequest.getFetchSourceExcludes());
        searchSearchRequest.setFetchSourceIncludes(searchRequest.getFetchSourceIncludes());
        searchSearchRequest.setGroupBy(searchContext.getGroupBy());
        searchSearchRequest.setGroupByRequests((Collection)searchRequest.getGroupByRequests());
        searchSearchRequest.setHighlightEnabled(queryConfig.isHighlightEnabled());
        searchSearchRequest.setHighlightFieldNames(queryConfig.getHighlightFieldNames());
        searchSearchRequest.setHighlightFragmentSize(queryConfig.getHighlightFragmentSize());
        searchSearchRequest.setHighlightSnippetSize(queryConfig.getHighlightSnippetSize());
        searchSearchRequest.setLocale(queryConfig.getLocale());
        searchSearchRequest.setHighlightRequireFieldMatch(queryConfig.isHighlightRequireFieldMatch());
        searchSearchRequest.setLuceneSyntax(GetterUtil.getBoolean((Object)searchContext.getAttribute("search.lucene.syntax")));
        String preference = (String)((Object)searchContext.getAttribute("elasticsearch.search.request.preference"));
        if (!Validator.isBlank((String)preference)) {
            searchSearchRequest.setPreference(preference);
        }
        searchSearchRequest.setScoreEnabled(queryConfig.isScoreEnabled());
        searchSearchRequest.setSelectedFieldNames(queryConfig.getSelectedFieldNames());
        int size = end - start;
        searchSearchRequest.setSize(Integer.valueOf(size));
        searchSearchRequest.setStart(Integer.valueOf(start));
        searchSearchRequest.setSorts(searchContext.getSorts());
        searchSearchRequest.setSorts((Collection)searchRequest.getSorts());
        searchSearchRequest.setStats(searchContext.getStats());
        return searchSearchRequest;
    }

    protected QuerySuggester getQuerySuggester() {
        return this._querySuggester;
    }

    protected boolean handle(Exception exception) {
        Throwable throwable = exception.getCause();
        if (throwable == null) {
            return false;
        }
        String message = throwable.getMessage();
        if (message == null) {
            return false;
        }
        if (message.contains("Text fields are not optimised for operations that require per-document field data")) {
            _log.error((Object)"Unable to aggregate facet on a nonkeyword field", (Throwable)exception);
            return true;
        }
        return false;
    }

    protected void setIndexNames(BaseSearchRequest baseSearchRequest, SearchRequest searchRequest, SearchContext searchContext) {
        baseSearchRequest.setIndexNames(this._getIndexes(searchRequest, searchContext));
    }

    protected void setQuery(BaseSearchRequest baseSearchRequest, SearchRequest searchRequest) {
        baseSearchRequest.setQuery(searchRequest.getQuery());
    }

    private CountSearchRequest _createCountSearchRequest(SearchContext searchContext, Query query) {
        CountSearchRequest countSearchRequest = new CountSearchRequest();
        this._prepare((BaseSearchRequest)countSearchRequest, this._getSearchRequest(searchContext), query, searchContext);
        return countSearchRequest;
    }

    private String _getExceptionMessage(RuntimeException runtimeException) {
        String message = runtimeException.toString();
        for (Throwable throwable : runtimeException.getSuppressed()) {
            message = message.concat("\nSuppressed: " + throwable.getMessage());
        }
        return message;
    }

    private String[] _getIndexes(SearchRequest searchRequest, SearchContext searchContext) {
        List indexes = searchRequest.getIndexes();
        if (!indexes.isEmpty()) {
            return indexes.toArray(new String[0]);
        }
        String indexName = this._indexNameBuilder.getIndexName(searchContext.getCompanyId());
        return new String[]{indexName};
    }

    private SearchRequest _getSearchRequest(SearchContext searchContext) {
        SearchRequestBuilder searchRequestBuilder = this._getSearchRequestBuilder(searchContext);
        return searchRequestBuilder.build();
    }

    private SearchRequestBuilder _getSearchRequestBuilder(SearchContext searchContext) {
        return this._searchRequestBuilderFactory.builder(searchContext);
    }

    private SearchResponseBuilder _getSearchResponseBuilder(SearchContext searchContext) {
        return this._searchResponseBuilderFactory.builder(searchContext);
    }

    private void _populateResponse(BaseSearchResponse baseSearchResponse, SearchResponseBuilder searchResponseBuilder) {
        searchResponseBuilder.aggregationResultsMap(baseSearchResponse.getAggregationResultsMap()).count(baseSearchResponse.getCount()).requestString(baseSearchResponse.getSearchRequestString()).responseString(baseSearchResponse.getSearchResponseString()).statsResponseMap(baseSearchResponse.getStatsResponseMap()).searchTimeValue(baseSearchResponse.getSearchTimeValue());
    }

    private void _populateResponse(SearchSearchResponse searchSearchResponse, SearchResponseBuilder searchResponseBuilder) {
        this._populateResponse((BaseSearchResponse)searchSearchResponse, searchResponseBuilder);
        searchResponseBuilder.groupByResponses(searchSearchResponse.getGroupByResponses());
    }

    private void _prepare(BaseSearchRequest baseSearchRequest, SearchRequest searchRequest, Query query, SearchContext searchContext) {
        baseSearchRequest.addComplexQueryParts((Collection)searchRequest.getComplexQueryParts());
        baseSearchRequest.setExplain(Boolean.valueOf(searchRequest.isExplain()));
        baseSearchRequest.setHighlight(searchRequest.getHighlight());
        baseSearchRequest.setIncludeResponseString(searchRequest.isIncludeResponseString());
        baseSearchRequest.setPostFilterQuery(searchRequest.getPostFilterQuery());
        baseSearchRequest.addPostFilterComplexQueryParts((Collection)searchRequest.getPostFilterComplexQueryParts());
        baseSearchRequest.setRescores(searchRequest.getRescores());
        baseSearchRequest.setStatsRequests((Collection)searchRequest.getStatsRequests());
        baseSearchRequest.setTrackTotalHits(Boolean.valueOf(this._elasticsearchConfigurationWrapper.trackTotalHits()));
        this._setAggregations(baseSearchRequest, searchRequest);
        this._setConnectionId(baseSearchRequest, searchRequest);
        this.setIndexNames(baseSearchRequest, searchRequest, searchContext);
        this._setLegacyQuery(baseSearchRequest, query);
        this._setLegacyPostFilter(baseSearchRequest, query);
        this._setPipelineAggregations(baseSearchRequest, searchRequest);
        this.setQuery(baseSearchRequest, searchRequest);
    }

    private void _setAggregations(BaseSearchRequest baseSearchRequest, SearchRequest searchRequest) {
        Map map = searchRequest.getAggregationsMap();
        for (Aggregation aggregation : map.values()) {
            baseSearchRequest.addAggregation(aggregation);
        }
    }

    private void _setConnectionId(BaseSearchRequest baseSearchRequest, SearchRequest searchRequest) {
        baseSearchRequest.setConnectionId(searchRequest.getConnectionId());
    }

    private void _setLegacyPostFilter(BaseSearchRequest baseSearchRequest, Query query) {
        if (query != null) {
            baseSearchRequest.setPostFilter(query.getPostFilter());
        }
    }

    private void _setLegacyQuery(BaseSearchRequest baseSearchRequest, Query query) {
        baseSearchRequest.setQuery(query);
    }

    private void _setPipelineAggregations(BaseSearchRequest baseSearchRequest, SearchRequest searchRequest) {
        Map map = searchRequest.getPipelineAggregationsMap();
        for (PipelineAggregation aggregation : map.values()) {
            baseSearchRequest.addPipelineAggregation(aggregation);
        }
    }
}

