/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.search.elasticsearch7.internal.filter;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.filter.TermsSetFilter;

import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermsSetQueryBuilder;

import org.osgi.service.component.annotations.Component;

/**
 * @author Marco Leo
 */
@Component(service = TermsSetFilterTranslator.class)
public class TermsSetFilterTranslatorImpl implements TermsSetFilterTranslator {

	@Override
	public QueryBuilder translate(TermsSetFilter termsSetFilter) {
		TermsSetQueryBuilder termsSetQueryBuilder = new TermsSetQueryBuilder(
			termsSetFilter.getFieldName(),
			ListUtil.toList(termsSetFilter.getValues()));

		if (!Validator.isBlank(termsSetFilter.getMinimumShouldMatchField())) {
			termsSetQueryBuilder.setMinimumShouldMatchField(
				termsSetFilter.getMinimumShouldMatchField());
		}

		return termsSetQueryBuilder;
	}

}