/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search;

import com.liferay.portal.kernel.search.suggest.Suggester;
import com.liferay.portal.kernel.search.suggest.SuggesterTranslator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.SuggestSearchRequestExecutor;
import com.liferay.portal.search.engine.adapter.search.SuggestSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SuggestSearchResponse;
import com.liferay.portal.search.engine.adapter.search.SuggestSearchResult;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.elasticsearch.search.suggest.SuggestionBuilder;
import org.elasticsearch.search.suggest.term.TermSuggestion;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SuggestSearchRequestExecutor.class})
public class SuggestSearchRequestExecutorImpl
implements SuggestSearchRequestExecutor {
    @Reference
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    @Reference(target="(search.engine.impl=Elasticsearch)")
    private SuggesterTranslator<SuggestionBuilder> _suggesterTranslator;

    @Override
    public SuggestSearchResponse execute(SuggestSearchRequest suggestSearchRequest) {
        SearchRequest searchRequest = this._createSearchRequest(suggestSearchRequest);
        SearchResponse searchResponse = this.getSearchResponse(searchRequest, suggestSearchRequest);
        Suggest suggest = searchResponse.getSuggest();
        SuggestSearchResponse suggestSearchResponse = new SuggestSearchResponse();
        if (suggest == null) {
            return suggestSearchResponse;
        }
        for (Suggest.Suggestion suggestion : suggest) {
            SuggestSearchResult suggestSearchResult = this.translate((Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>>)suggestion);
            suggestSearchResponse.addSuggestSearchResult(suggestSearchResult);
        }
        return suggestSearchResponse;
    }

    protected SearchResponse getSearchResponse(SearchRequest searchRequest, SuggestSearchRequest suggestSearchRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(suggestSearchRequest.getConnectionId(), suggestSearchRequest.isPreferLocalCluster());
        try {
            return restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected SuggestSearchResult.Entry.Option translate(Suggest.Suggestion.Entry.Option suggestionEntryOption) {
        Text text = suggestionEntryOption.getText();
        SuggestSearchResult.Entry.Option suggesterResultEntryOption = new SuggestSearchResult.Entry.Option(text.string(), suggestionEntryOption.getScore());
        if (suggestionEntryOption.getHighlighted() != null) {
            Text highlightedText = suggestionEntryOption.getHighlighted();
            suggesterResultEntryOption.setHighlightedText(highlightedText.string());
        }
        if (suggestionEntryOption instanceof TermSuggestion.Entry.Option) {
            TermSuggestion.Entry.Option termSuggestionEntryOption = (TermSuggestion.Entry.Option)suggestionEntryOption;
            suggesterResultEntryOption.setFrequency(Integer.valueOf(termSuggestionEntryOption.getFreq()));
        }
        return suggesterResultEntryOption;
    }

    protected SuggestSearchResult.Entry translate(Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option> suggestionEntry) {
        Text text = suggestionEntry.getText();
        SuggestSearchResult.Entry suggesterResultEntry = new SuggestSearchResult.Entry(text.string());
        List suggestionEntryOptions = suggestionEntry.getOptions();
        for (Suggest.Suggestion.Entry.Option suggestionEntryOption : suggestionEntryOptions) {
            SuggestSearchResult.Entry.Option suggesterResultEntryOption = this.translate(suggestionEntryOption);
            suggesterResultEntry.addOption(suggesterResultEntryOption);
        }
        return suggesterResultEntry;
    }

    protected SuggestSearchResult translate(Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> suggestion) {
        SuggestSearchResult suggestSearchResult = new SuggestSearchResult(suggestion.getName());
        for (Suggest.Suggestion.Entry suggestionEntry : suggestion) {
            SuggestSearchResult.Entry suggesterResultEntry = this.translate((Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>)suggestionEntry);
            suggestSearchResult.addEntry(suggesterResultEntry);
        }
        return suggestSearchResult;
    }

    private SearchRequest _createSearchRequest(SuggestSearchRequest suggestSearchRequest) {
        SearchRequest searchRequest = new SearchRequest(suggestSearchRequest.getIndexNames());
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        Map suggesterMap = suggestSearchRequest.getSuggesterMap();
        SuggestBuilder suggestBuilder = new SuggestBuilder();
        if (!Validator.isBlank((String)suggestSearchRequest.getGlobalText())) {
            suggestBuilder.setGlobalText(suggestSearchRequest.getGlobalText());
        }
        for (Map.Entry entry : suggesterMap.entrySet()) {
            Suggester suggester = (Suggester)entry.getValue();
            String suggesterName = (String)entry.getKey();
            SuggestionBuilder suggestionBuilder = (SuggestionBuilder)this._suggesterTranslator.translate(suggester, null);
            suggestBuilder.addSuggestion(suggesterName, suggestionBuilder);
        }
        searchSourceBuilder.suggest(suggestBuilder);
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }
}

