/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search;

import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.search.aggregation.AggregationTranslator;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregationTranslator;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetTranslator;
import com.liferay.portal.search.elasticsearch7.internal.filter.FilterToQueryBuilderTranslator;
import com.liferay.portal.search.elasticsearch7.internal.query.QueryToQueryBuilderTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.CommonSearchSourceBuilderAssembler;
import com.liferay.portal.search.elasticsearch7.internal.stats.StatsTranslator;
import com.liferay.portal.search.engine.adapter.search.BaseSearchRequest;
import com.liferay.portal.search.filter.ComplexQueryBuilderFactory;
import com.liferay.portal.search.filter.ComplexQueryPart;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.rescore.Rescore;
import com.liferay.portal.search.stats.StatsRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.rescore.QueryRescoreMode;
import org.elasticsearch.search.rescore.QueryRescorerBuilder;
import org.elasticsearch.search.rescore.RescorerBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommonSearchSourceBuilderAssembler.class})
public class CommonSearchSourceBuilderAssemblerImpl
implements CommonSearchSourceBuilderAssembler {
    @Reference(target="(search.engine.impl=Elasticsearch)")
    private AggregationTranslator<AggregationBuilder> _aggregationTranslator;
    @Reference
    private ComplexQueryBuilderFactory _complexQueryBuilderFactory;
    @Reference
    private FacetTranslator _facetTranslator;
    @Reference
    private FilterToQueryBuilderTranslator _filterToQueryBuilderTranslator;
    @Reference
    private com.liferay.portal.search.elasticsearch7.internal.legacy.query.QueryToQueryBuilderTranslator _legacyQueryToQueryBuilderTranslator;
    @Reference(target="(search.engine.impl=Elasticsearch)")
    private PipelineAggregationTranslator<PipelineAggregationBuilder> _pipelineAggregationTranslator;
    @Reference
    private QueryToQueryBuilderTranslator _queryToQueryBuilderTranslator;
    @Reference
    private StatsTranslator _statsTranslator;

    @Override
    public void assemble(SearchSourceBuilder searchSourceBuilder, BaseSearchRequest baseSearchRequest, SearchRequest searchRequest) {
        this._setAggregations(searchSourceBuilder, baseSearchRequest);
        this._setExplain(searchSourceBuilder, baseSearchRequest);
        this._setFacets(searchSourceBuilder, baseSearchRequest);
        this._setIndexBoosts(searchSourceBuilder, baseSearchRequest);
        this._setIndices(searchRequest, baseSearchRequest);
        this._setMinScore(searchSourceBuilder, baseSearchRequest);
        this._setPipelineAggregations(searchSourceBuilder, baseSearchRequest);
        this._setPostFilter(searchSourceBuilder, baseSearchRequest);
        this.setQuery(searchSourceBuilder, baseSearchRequest);
        this._setRequestCache(searchRequest, baseSearchRequest);
        this._setRescorer(searchSourceBuilder, baseSearchRequest);
        this._setStatsRequests(searchSourceBuilder, baseSearchRequest);
        this._setTimeout(searchSourceBuilder, baseSearchRequest);
        this._setTrackTotalHits(searchSourceBuilder, baseSearchRequest);
        this._setTypes(searchRequest, baseSearchRequest);
        searchRequest.source(searchSourceBuilder);
    }

    protected void setQuery(SearchSourceBuilder searchSourceBuilder, BaseSearchRequest baseSearchRequest) {
        searchSourceBuilder.query(this._getQueryBuilder(baseSearchRequest));
    }

    protected BoolQueryBuilder translate(List<ComplexQueryPart> complexQueryParts) {
        if (ListUtil.isEmpty(complexQueryParts)) {
            return null;
        }
        com.liferay.portal.search.query.BooleanQuery booleanQuery = this._buildComplexQuery(complexQueryParts);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        this._transfer(booleanQuery, boolQueryBuilder);
        return boolQueryBuilder;
    }

    protected QueryRescoreMode translate(Rescore.ScoreMode scoreMode) {
        if (scoreMode == Rescore.ScoreMode.AVG) {
            return QueryRescoreMode.Avg;
        }
        if (scoreMode == Rescore.ScoreMode.MAX) {
            return QueryRescoreMode.Max;
        }
        if (scoreMode == Rescore.ScoreMode.MIN) {
            return QueryRescoreMode.Min;
        }
        if (scoreMode == Rescore.ScoreMode.MULTIPLY) {
            return QueryRescoreMode.Multiply;
        }
        if (scoreMode == Rescore.ScoreMode.TOTAL) {
            return QueryRescoreMode.Total;
        }
        throw new IllegalArgumentException("Invalid Rescore.ScoreMode: " + scoreMode);
    }

    private com.liferay.portal.search.query.BooleanQuery _buildComplexQuery(List<ComplexQueryPart> complexQueryParts) {
        return (com.liferay.portal.search.query.BooleanQuery)this._complexQueryBuilderFactory.builder().addParts(complexQueryParts).build();
    }

    private QueryBuilder _buildQueryBuilder(BaseSearchRequest baseSearchRequest) {
        List postFilterQueryParts;
        QueryBuilder queryBuilder = null;
        if (baseSearchRequest.getPostFilterQuery() != null) {
            queryBuilder = this._queryToQueryBuilderTranslator.translate(baseSearchRequest.getPostFilterQuery());
        }
        if (!(postFilterQueryParts = baseSearchRequest.getPostFilterComplexQueryParts()).isEmpty()) {
            queryBuilder = this._combine(queryBuilder, postFilterQueryParts);
        }
        return queryBuilder;
    }

    private void _combine(BoolQueryBuilder boolQueryBuilder, ComplexQueryPart complexQueryPart) {
        Query query = this._complexQueryBuilderFactory.builder().buildPart(complexQueryPart);
        if (query == null) {
            return;
        }
        String occur = GetterUtil.getString((String)complexQueryPart.getOccur(), (String)"must");
        if (occur.equals("filter")) {
            boolQueryBuilder.filter(this._translateQuery(query));
        } else if (occur.equals("must")) {
            boolQueryBuilder.must(this._translateQuery(query));
        } else if (occur.equals("must_not")) {
            boolQueryBuilder.mustNot(this._translateQuery(query));
        } else if (occur.equals("should")) {
            boolQueryBuilder.should(this._translateQuery(query));
        }
    }

    private QueryBuilder _combine(BoolQueryBuilder boolQueryBuilder, QueryBuilder queryBuilder, BiConsumer<BoolQueryBuilder, QueryBuilder> biConsumer) {
        if (boolQueryBuilder == null) {
            return queryBuilder;
        }
        if (queryBuilder != null) {
            biConsumer.accept(boolQueryBuilder, queryBuilder);
        }
        return boolQueryBuilder;
    }

    private QueryBuilder _combine(QueryBuilder queryBuilder, List<ComplexQueryPart> complexQueryParts) {
        ArrayList<ComplexQueryPart> additiveComplexQueryParts = new ArrayList<ComplexQueryPart>();
        ArrayList<ComplexQueryPart> nonadditiveComplexQueryParts = new ArrayList<ComplexQueryPart>();
        for (ComplexQueryPart complexQueryPart : complexQueryParts) {
            if (complexQueryPart.isAdditive()) {
                additiveComplexQueryParts.add(complexQueryPart);
                continue;
            }
            if (complexQueryPart.isRootClause() && queryBuilder instanceof BoolQueryBuilder) {
                BoolQueryBuilder boolQueryBuilder = (BoolQueryBuilder)queryBuilder;
                this._combine(boolQueryBuilder, complexQueryPart);
                continue;
            }
            nonadditiveComplexQueryParts.add(complexQueryPart);
        }
        QueryBuilder queryBuilder1 = this._combine(this.translate(nonadditiveComplexQueryParts), queryBuilder, BoolQueryBuilder::must);
        return this._combine(this.translate(additiveComplexQueryParts), queryBuilder1, BoolQueryBuilder::should);
    }

    private QueryBuilder _combine(QueryBuilder queryBuilder1, QueryBuilder queryBuilder2) {
        if (queryBuilder1 == null) {
            return queryBuilder2;
        }
        if (queryBuilder2 == null) {
            return queryBuilder1;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        return boolQueryBuilder.must(queryBuilder1).must(queryBuilder2);
    }

    private void _copy(List<Query> clauses, Consumer<QueryBuilder> consumer) {
        for (Query query : clauses) {
            consumer.accept(this._translateQuery(query));
        }
    }

    private QueryBuilder _getQueryBuilder(BaseSearchRequest baseSearchRequest) {
        QueryBuilder queryBuilder1 = this._combine(this._translateQuery(baseSearchRequest.getQuery()), this._translateQuery(baseSearchRequest.getQuery71()));
        List complexQueryParts = baseSearchRequest.getComplexQueryParts();
        if (complexQueryParts.isEmpty()) {
            QueryBuilder queryBuilder2 = this._combine(this.translate(Collections.emptyList()), queryBuilder1, BoolQueryBuilder::must);
            return this._combine(this.translate(Collections.emptyList()), queryBuilder2, BoolQueryBuilder::should);
        }
        return this._combine(queryBuilder1, complexQueryParts);
    }

    private void _setAggregations(SearchSourceBuilder searchSourceBuilder, BaseSearchRequest baseSearchRequest) {
        Map aggregationsMap = baseSearchRequest.getAggregationsMap();
        if (MapUtil.isNotEmpty((Map)aggregationsMap)) {
            Collection aggregations = aggregationsMap.values();
            aggregations.forEach(aggregation -> {
                AggregationBuilder aggregationBuilder = (AggregationBuilder)this._aggregationTranslator.translate(aggregation);
                searchSourceBuilder.aggregation(aggregationBuilder);
            });
        }
    }

    private void _setExplain(SearchSourceBuilder searchSourceBuilder, BaseSearchRequest baseSearchRequest) {
        if (baseSearchRequest.getExplain() != null) {
            searchSourceBuilder.explain(baseSearchRequest.getExplain());
        }
    }

    private void _setFacets(SearchSourceBuilder searchSourceBuilder, BaseSearchRequest baseSearchRequest) {
        this._facetTranslator.translate(searchSourceBuilder, baseSearchRequest.getQuery71(), baseSearchRequest.getFacets(), baseSearchRequest.isBasicFacetSelection());
    }

    private void _setIndexBoosts(SearchSourceBuilder searchSourceBuilder, BaseSearchRequest baseSearchRequest) {
        Map indexBoosts = baseSearchRequest.getIndexBoosts();
        if (MapUtil.isNotEmpty((Map)indexBoosts)) {
            indexBoosts.forEach((arg_0, arg_1) -> ((SearchSourceBuilder)searchSourceBuilder).indexBoost(arg_0, arg_1));
        }
    }

    private void _setIndices(SearchRequest searchRequest, BaseSearchRequest baseSearchRequest) {
        searchRequest.indices(baseSearchRequest.getIndexNames());
    }

    private void _setMinScore(SearchSourceBuilder searchSourceBuilder, BaseSearchRequest baseSearchRequest) {
        if (baseSearchRequest.getMinimumScore() != null) {
            searchSourceBuilder.minScore(baseSearchRequest.getMinimumScore().floatValue());
        }
    }

    private void _setPipelineAggregations(SearchSourceBuilder searchSourceBuilder, BaseSearchRequest baseSearchRequest) {
        Map pipelineAggregationsMap = baseSearchRequest.getPipelineAggregationsMap();
        if (MapUtil.isNotEmpty((Map)pipelineAggregationsMap)) {
            Collection pipelineAggregations = pipelineAggregationsMap.values();
            pipelineAggregations.forEach(pipelineAggregation -> {
                PipelineAggregationBuilder pipelineAggregationBuilder = (PipelineAggregationBuilder)this._pipelineAggregationTranslator.translate(pipelineAggregation);
                searchSourceBuilder.aggregation(pipelineAggregationBuilder);
            });
        }
    }

    private void _setPostFilter(SearchSourceBuilder searchSourceBuilder, BaseSearchRequest baseSearchRequest) {
        QueryBuilder queryBuilder = this._buildQueryBuilder(baseSearchRequest);
        if (queryBuilder != null) {
            searchSourceBuilder.postFilter(queryBuilder);
        } else if (baseSearchRequest.getPostFilter() != null) {
            searchSourceBuilder.postFilter(this._filterToQueryBuilderTranslator.translate(baseSearchRequest.getPostFilter(), null));
        }
    }

    private void _setRequestCache(SearchRequest searchRequest, BaseSearchRequest baseSearchRequest) {
        if (baseSearchRequest.getRequestCache() != null) {
            searchRequest.requestCache(baseSearchRequest.getRequestCache());
        }
    }

    private void _setRescorer(SearchSourceBuilder searchSourceBuilder, BaseSearchRequest baseSearchRequest) {
        this._setRescorers(searchSourceBuilder, baseSearchRequest.getRescores());
        this._setRescorerQuery(searchSourceBuilder, baseSearchRequest.getRescoreQuery());
    }

    private void _setRescorerQuery(SearchSourceBuilder searchSourceBuilder, Query query) {
        if (query == null) {
            return;
        }
        searchSourceBuilder.addRescorer((RescorerBuilder)new QueryRescorerBuilder(this._queryToQueryBuilderTranslator.translate(query)));
    }

    private void _setRescorers(SearchSourceBuilder searchSourceBuilder, List<Rescore> rescores) {
        if (rescores == null) {
            return;
        }
        for (Rescore rescore : rescores) {
            QueryRescorerBuilder queryRescorerBuilder = new QueryRescorerBuilder(this._queryToQueryBuilderTranslator.translate(rescore.getQuery()));
            if (rescore.getQueryWeight() != null) {
                queryRescorerBuilder.setQueryWeight(rescore.getQueryWeight().floatValue());
            }
            if (rescore.getRescoreQueryWeight() != null) {
                queryRescorerBuilder.setRescoreQueryWeight(rescore.getRescoreQueryWeight().floatValue());
            }
            if (rescore.getScoreMode() != null) {
                queryRescorerBuilder.setScoreMode(this.translate(rescore.getScoreMode()));
            }
            if (rescore.getWindowSize() != null) {
                queryRescorerBuilder.windowSize(rescore.getWindowSize().intValue());
            }
            searchSourceBuilder.addRescorer((RescorerBuilder)queryRescorerBuilder);
        }
    }

    private void _setStatsRequests(SearchSourceBuilder searchSourceBuilder, BaseSearchRequest baseSearchRequest) {
        List statsRequests = baseSearchRequest.getStatsRequests();
        if (ListUtil.isNotEmpty((List)statsRequests)) {
            statsRequests.forEach(statsRequest -> this._statsTranslator.populateRequest(searchSourceBuilder, (StatsRequest)statsRequest));
        }
    }

    private void _setTimeout(SearchSourceBuilder searchSourceBuilder, BaseSearchRequest baseSearchRequest) {
        if (baseSearchRequest.getTimeoutInMilliseconds() != null) {
            searchSourceBuilder.timeout(TimeValue.timeValueMillis((long)baseSearchRequest.getTimeoutInMilliseconds()));
        }
    }

    private void _setTrackTotalHits(SearchSourceBuilder searchSourceBuilder, BaseSearchRequest baseSearchRequest) {
        if (baseSearchRequest.getTrackTotalHits() != null) {
            searchSourceBuilder.trackTotalHits(baseSearchRequest.getTrackTotalHits().booleanValue());
        }
    }

    private void _setTypes(SearchRequest searchRequest, BaseSearchRequest baseSearchRequest) {
        if (baseSearchRequest.getTypes() != null) {
            searchRequest.types(baseSearchRequest.getTypes());
        }
    }

    private void _transfer(com.liferay.portal.search.query.BooleanQuery booleanQuery, BoolQueryBuilder boolQueryBuilder) {
        this._copy(booleanQuery.getFilterQueryClauses(), arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).filter(arg_0));
        this._copy(booleanQuery.getMustNotQueryClauses(), arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).mustNot(arg_0));
        this._copy(booleanQuery.getMustQueryClauses(), arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).must(arg_0));
        this._copy(booleanQuery.getShouldQueryClauses(), arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).should(arg_0));
    }

    private QueryBuilder _translateQuery(com.liferay.portal.kernel.search.Query query) {
        if (query == null) {
            return null;
        }
        QueryBuilder queryBuilder = this._legacyQueryToQueryBuilderTranslator.translate(query, null);
        if (query.getPreBooleanFilter() == null || query instanceof BooleanQuery) {
            return queryBuilder;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.filter(this._filterToQueryBuilderTranslator.translate((Filter)query.getPreBooleanFilter(), null));
        boolQueryBuilder.must(queryBuilder);
        return boolQueryBuilder;
    }

    private QueryBuilder _translateQuery(Query query) {
        if (query != null) {
            return this._queryToQueryBuilderTranslator.translate(query);
        }
        return null;
    }
}

