/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document;

import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document.ElasticsearchBulkableDocumentRequestTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document.IndexDocumentRequestExecutor;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentResponse;
import java.io.IOException;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.rest.RestStatus;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={IndexDocumentRequestExecutor.class})
public class IndexDocumentRequestExecutorImpl
implements IndexDocumentRequestExecutor {
    @Reference(target="(search.engine.impl=Elasticsearch)")
    private ElasticsearchBulkableDocumentRequestTranslator _elasticsearchBulkableDocumentRequestTranslator;
    @Reference
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public IndexDocumentResponse execute(IndexDocumentRequest indexDocumentRequest) {
        IndexRequest indexRequest = this._elasticsearchBulkableDocumentRequestTranslator.translate(indexDocumentRequest);
        IndexResponse indexResponse = this._getIndexResponse(indexRequest, indexDocumentRequest);
        RestStatus restStatus = indexResponse.status();
        return new IndexDocumentResponse(restStatus.getStatus(), indexResponse.getId());
    }

    private IndexResponse _getIndexResponse(IndexRequest indexRequest, IndexDocumentRequest indexDocumentRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(indexDocumentRequest.getConnectionId(), indexDocumentRequest.isPreferLocalCluster());
        try {
            return restHighLevelClient.index(indexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

