/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.helper.SearchLogHelperUtil;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document.BulkDocumentRequestExecutor;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document.ElasticsearchBulkableDocumentRequestTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document.configuration.BulkDocumentRequestRetryConfiguration;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentItemResponse;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentResponse;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DeleteDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateDocumentRequest;
import java.util.Map;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document.configuration.BulkDocumentRequestRetryConfiguration"}, service={BulkDocumentRequestExecutor.class})
public class BulkDocumentRequestExecutorImpl
implements BulkDocumentRequestExecutor {
    private static final Log _log = LogFactoryUtil.getLog(BulkDocumentRequestExecutorImpl.class);
    @Reference(target="(search.engine.impl=Elasticsearch)")
    private ElasticsearchBulkableDocumentRequestTranslator _elasticsearchBulkableDocumentRequestTranslator;
    @Reference
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    private volatile int _numberOfTries;
    private volatile int _waitInSeconds;

    @Override
    public BulkDocumentResponse execute(BulkDocumentRequest bulkDocumentRequest) {
        BulkRequest bulkRequest = this.createBulkRequest(bulkDocumentRequest);
        BulkResponse bulkResponse = this._getBulkResponse(bulkRequest, bulkDocumentRequest);
        SearchLogHelperUtil.logActionResponse(_log, bulkResponse);
        TimeValue timeValue = bulkResponse.getTook();
        BulkDocumentResponse bulkDocumentResponse = new BulkDocumentResponse(timeValue.getMillis());
        for (BulkItemResponse bulkItemResponse : bulkResponse.getItems()) {
            BulkDocumentItemResponse bulkDocumentItemResponse = new BulkDocumentItemResponse();
            bulkDocumentResponse.addBulkDocumentItemResponse(bulkDocumentItemResponse);
            bulkDocumentItemResponse.setId(bulkItemResponse.getId());
            bulkDocumentItemResponse.setIndex(bulkItemResponse.getIndex());
            bulkDocumentItemResponse.setFailureMessage(bulkItemResponse.getFailureMessage());
            bulkDocumentItemResponse.setType(bulkItemResponse.getType());
            bulkDocumentItemResponse.setVersion(bulkItemResponse.getVersion());
            RestStatus restStatus = bulkItemResponse.status();
            if (bulkItemResponse.isFailed()) {
                bulkDocumentResponse.setErrors(true);
                BulkItemResponse.Failure bulkItemFailureResponse = bulkItemResponse.getFailure();
                bulkDocumentItemResponse.setAborted(bulkItemFailureResponse.isAborted());
                bulkDocumentItemResponse.setCause(bulkItemFailureResponse.getCause());
                restStatus = bulkItemFailureResponse.getStatus();
            }
            bulkDocumentItemResponse.setStatus(restStatus.getStatus());
        }
        return bulkDocumentResponse;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        BulkDocumentRequestRetryConfiguration bulkDocumentRequestRetryConfiguration = (BulkDocumentRequestRetryConfiguration)ConfigurableUtil.createConfigurable(BulkDocumentRequestRetryConfiguration.class, properties);
        this._numberOfTries = bulkDocumentRequestRetryConfiguration.numberOfTries();
        this._waitInSeconds = bulkDocumentRequestRetryConfiguration.waitInSeconds();
    }

    protected BulkRequest createBulkRequest(BulkDocumentRequest bulkDocumentRequest) {
        BulkRequest bulkRequest = new BulkRequest();
        if (bulkDocumentRequest.isRefresh()) {
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        }
        for (BulkableDocumentRequest bulkableDocumentRequest : bulkDocumentRequest.getBulkableDocumentRequests()) {
            bulkableDocumentRequest.accept(request -> {
                if (request instanceof DeleteDocumentRequest) {
                    DeleteRequest deleteRequest = this._elasticsearchBulkableDocumentRequestTranslator.translate((DeleteDocumentRequest)request);
                    bulkRequest.add(deleteRequest);
                } else if (request instanceof IndexDocumentRequest) {
                    IndexRequest indexRequest = this._elasticsearchBulkableDocumentRequestTranslator.translate((IndexDocumentRequest)request);
                    bulkRequest.add(indexRequest);
                } else if (request instanceof UpdateDocumentRequest) {
                    UpdateRequest updateRequest = this._elasticsearchBulkableDocumentRequestTranslator.translate((UpdateDocumentRequest)request);
                    bulkRequest.add(updateRequest);
                } else {
                    throw new IllegalArgumentException("No translator available for: " + request);
                }
            });
        }
        return bulkRequest;
    }

    private BulkResponse _getBulkResponse(BulkRequest bulkRequest, BulkDocumentRequest bulkDocumentRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(bulkDocumentRequest.getConnectionId(), bulkDocumentRequest.isPreferLocalCluster());
        int i = 0;
        while (true) {
            try {
                return restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            }
            catch (Exception exception) {
                if (i++ >= this._numberOfTries) {
                    if (this._numberOfTries > 1) {
                        _log.error((Object)("All " + this._numberOfTries + " tries failed to get a bulk response"));
                    }
                    throw new RuntimeException(exception);
                }
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"There was an exception during getting a response to ", "a request from the search server, retrying after ", this._waitInSeconds, " seconds (", i, "/", this._numberOfTries, "). ", exception}));
                try {
                    Thread.sleep((long)this._waitInSeconds * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    _log.error((Throwable)interruptedException);
                    throw new RuntimeException(exception);
                }
            }
        }
    }
}

