/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.cluster;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.cluster.ClusterHealthStatusTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.cluster.HealthClusterRequestExecutor;
import com.liferay.portal.search.engine.adapter.cluster.HealthClusterRequest;
import com.liferay.portal.search.engine.adapter.cluster.HealthClusterResponse;
import java.io.IOException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.client.ClusterClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.core.TimeValue;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={HealthClusterRequestExecutor.class})
public class HealthClusterRequestExecutorImpl
implements HealthClusterRequestExecutor {
    @Reference
    private ClusterHealthStatusTranslator _clusterHealthStatusTranslator;
    @Reference
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public HealthClusterResponse execute(HealthClusterRequest healthClusterRequest) {
        ClusterHealthRequest clusterHealthRequest = this.createClusterHealthRequest(healthClusterRequest);
        ClusterHealthResponse clusterHealthResponse = this._getClusterHealthResponse(clusterHealthRequest, healthClusterRequest);
        ClusterHealthStatus clusterHealthStatus = clusterHealthResponse.getStatus();
        return new HealthClusterResponse(this._clusterHealthStatusTranslator.translate(clusterHealthStatus), clusterHealthResponse.toString());
    }

    protected ClusterHealthRequest createClusterHealthRequest(HealthClusterRequest healthClusterRequest) {
        long timeout;
        ClusterHealthRequest clusterHealthRequest = new ClusterHealthRequest();
        if (ArrayUtil.isNotEmpty((Object[])healthClusterRequest.getIndexNames())) {
            clusterHealthRequest.indices(healthClusterRequest.getIndexNames());
        }
        if ((timeout = healthClusterRequest.getTimeout()) > 0L) {
            clusterHealthRequest.masterNodeTimeout(TimeValue.timeValueMillis((long)timeout));
            clusterHealthRequest.timeout(TimeValue.timeValueMillis((long)timeout));
        }
        if (healthClusterRequest.getWaitForClusterHealthStatus() != null) {
            clusterHealthRequest.waitForStatus(this._clusterHealthStatusTranslator.translate(healthClusterRequest.getWaitForClusterHealthStatus()));
        }
        return clusterHealthRequest;
    }

    private ClusterHealthResponse _getClusterHealthResponse(ClusterHealthRequest clusterHealthRequest, HealthClusterRequest healthClusterRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(healthClusterRequest.getConnectionId(), healthClusterRequest.isPreferLocalCluster());
        ClusterClient clusterClient = restHighLevelClient.cluster();
        try {
            return clusterClient.health(clusterHealthRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

