/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.query.function.score;

import com.liferay.portal.search.elasticsearch7.internal.script.ScriptTranslator;
import com.liferay.portal.search.query.function.score.ExponentialDecayScoreFunction;
import com.liferay.portal.search.query.function.score.FieldValueFactorScoreFunction;
import com.liferay.portal.search.query.function.score.GaussianDecayScoreFunction;
import com.liferay.portal.search.query.function.score.LinearDecayScoreFunction;
import com.liferay.portal.search.query.function.score.RandomScoreFunction;
import com.liferay.portal.search.query.function.score.ScoreFunctionTranslator;
import com.liferay.portal.search.query.function.score.ScriptScoreFunction;
import com.liferay.portal.search.query.function.score.WeightScoreFunction;
import org.elasticsearch.common.lucene.search.function.FieldValueFactorFunction;
import org.elasticsearch.index.query.functionscore.ExponentialDecayFunctionBuilder;
import org.elasticsearch.index.query.functionscore.FieldValueFactorFunctionBuilder;
import org.elasticsearch.index.query.functionscore.GaussDecayFunctionBuilder;
import org.elasticsearch.index.query.functionscore.LinearDecayFunctionBuilder;
import org.elasticsearch.index.query.functionscore.RandomScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.ScriptScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.WeightBuilder;

public class ElasticsearchScoreFunctionTranslator
implements ScoreFunctionTranslator<ScoreFunctionBuilder<?>> {
    private final ScriptTranslator _scriptTranslator = new ScriptTranslator();

    public ScoreFunctionBuilder<?> translate(ExponentialDecayScoreFunction exponentialDecayScoreFunction) {
        if (exponentialDecayScoreFunction.getDecay() != null) {
            return new ExponentialDecayFunctionBuilder(exponentialDecayScoreFunction.getField(), exponentialDecayScoreFunction.getOrigin(), exponentialDecayScoreFunction.getScale(), exponentialDecayScoreFunction.getOffset(), exponentialDecayScoreFunction.getDecay().doubleValue());
        }
        return new ExponentialDecayFunctionBuilder(exponentialDecayScoreFunction.getField(), exponentialDecayScoreFunction.getOrigin(), exponentialDecayScoreFunction.getScale(), exponentialDecayScoreFunction.getOffset());
    }

    public ScoreFunctionBuilder<?> translate(FieldValueFactorScoreFunction fieldValueFactorScoreFunction) {
        FieldValueFactorFunctionBuilder fieldValueFactorFunctionBuilder = new FieldValueFactorFunctionBuilder(fieldValueFactorScoreFunction.getField());
        if (fieldValueFactorScoreFunction.getFactor() != null) {
            fieldValueFactorFunctionBuilder.factor(fieldValueFactorScoreFunction.getFactor().floatValue());
        }
        if (fieldValueFactorScoreFunction.getMissing() != null) {
            fieldValueFactorFunctionBuilder.missing(fieldValueFactorScoreFunction.getMissing().doubleValue());
        }
        if (fieldValueFactorScoreFunction.getModifier() != null) {
            String modifier = fieldValueFactorScoreFunction.getModifier().toString();
            fieldValueFactorFunctionBuilder.modifier(FieldValueFactorFunction.Modifier.fromString((String)modifier));
        }
        return fieldValueFactorFunctionBuilder;
    }

    public ScoreFunctionBuilder<?> translate(GaussianDecayScoreFunction gaussianDecayScoreFunction) {
        if (gaussianDecayScoreFunction.getDecay() != null) {
            return new GaussDecayFunctionBuilder(gaussianDecayScoreFunction.getField(), gaussianDecayScoreFunction.getOrigin(), gaussianDecayScoreFunction.getScale(), gaussianDecayScoreFunction.getOffset(), gaussianDecayScoreFunction.getDecay().doubleValue());
        }
        return new GaussDecayFunctionBuilder(gaussianDecayScoreFunction.getField(), gaussianDecayScoreFunction.getOrigin(), gaussianDecayScoreFunction.getScale(), gaussianDecayScoreFunction.getOffset());
    }

    public ScoreFunctionBuilder<?> translate(LinearDecayScoreFunction linearDecayScoreFunction) {
        if (linearDecayScoreFunction.getDecay() != null) {
            return new LinearDecayFunctionBuilder(linearDecayScoreFunction.getField(), linearDecayScoreFunction.getOrigin(), linearDecayScoreFunction.getScale(), linearDecayScoreFunction.getOffset(), linearDecayScoreFunction.getDecay().doubleValue());
        }
        return new LinearDecayFunctionBuilder(linearDecayScoreFunction.getField(), linearDecayScoreFunction.getOrigin(), linearDecayScoreFunction.getScale(), linearDecayScoreFunction.getOffset());
    }

    public ScoreFunctionBuilder<?> translate(RandomScoreFunction randomScoreFunction) {
        RandomScoreFunctionBuilder randomScoreFunctionBuilder = new RandomScoreFunctionBuilder();
        if (randomScoreFunction.getField() != null) {
            randomScoreFunctionBuilder.setField(randomScoreFunction.getField());
        }
        if (randomScoreFunction.getSeed() != null) {
            randomScoreFunctionBuilder.seed(randomScoreFunction.getSeed().intValue());
        }
        return randomScoreFunctionBuilder;
    }

    public ScoreFunctionBuilder<?> translate(ScriptScoreFunction scriptScoreFunction) {
        return new ScriptScoreFunctionBuilder(this._scriptTranslator.translate(scriptScoreFunction.getScript()));
    }

    public ScoreFunctionBuilder<?> translate(WeightScoreFunction weightScoreFunction) {
        return new WeightBuilder();
    }
}

