/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.query;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.query.BaseMatchQueryTranslatorImpl;
import com.liferay.portal.search.elasticsearch7.internal.query.MultiMatchQueryTranslator;
import com.liferay.portal.search.query.MultiMatchQuery;
import java.util.Map;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.ZeroTermsQueryOption;
import org.osgi.service.component.annotations.Component;

@Component(service={MultiMatchQueryTranslator.class})
public class MultiMatchQueryTranslatorImpl
extends BaseMatchQueryTranslatorImpl
implements MultiMatchQueryTranslator {
    @Override
    public QueryBuilder translate(MultiMatchQuery multiMatchQuery) {
        MultiMatchQueryBuilder multiMatchQueryBuilder = QueryBuilders.multiMatchQuery((Object)multiMatchQuery.getValue(), (String[])new String[0]);
        if (Validator.isNotNull((String)multiMatchQuery.getAnalyzer())) {
            multiMatchQueryBuilder.analyzer(multiMatchQuery.getAnalyzer());
        }
        if (multiMatchQuery.getCutOffFrequency() != null) {
            multiMatchQueryBuilder.cutoffFrequency(multiMatchQuery.getCutOffFrequency());
        }
        Map fieldsBoosts = multiMatchQuery.getFieldsBoosts();
        for (Map.Entry entry : fieldsBoosts.entrySet()) {
            Float boost = (Float)entry.getValue();
            String field = (String)entry.getKey();
            if (boost == null) {
                multiMatchQueryBuilder.field(field);
                continue;
            }
            multiMatchQueryBuilder.field(field, boost.floatValue());
        }
        if (multiMatchQuery.getFuzziness() != null) {
            multiMatchQueryBuilder.fuzziness((Object)Fuzziness.build((Object)multiMatchQuery.getFuzziness()));
        }
        if (multiMatchQuery.getFuzzyRewriteMethod() != null) {
            String multiMatchQueryFuzzyRewriteMethod = this.translate(multiMatchQuery.getFuzzyRewriteMethod());
            multiMatchQueryBuilder.fuzzyRewrite(multiMatchQueryFuzzyRewriteMethod);
        }
        if (multiMatchQuery.getMaxExpansions() != null) {
            multiMatchQueryBuilder.maxExpansions(multiMatchQuery.getMaxExpansions().intValue());
        }
        if (Validator.isNotNull((String)multiMatchQuery.getMinShouldMatch())) {
            multiMatchQueryBuilder.minimumShouldMatch(multiMatchQuery.getMinShouldMatch());
        }
        if (multiMatchQuery.getOperator() != null) {
            Operator matchQueryBuilderOperator = this.translate(multiMatchQuery.getOperator());
            multiMatchQueryBuilder.operator(matchQueryBuilderOperator);
        }
        if (multiMatchQuery.getPrefixLength() != null) {
            multiMatchQueryBuilder.prefixLength(multiMatchQuery.getPrefixLength().intValue());
        }
        if (multiMatchQuery.getSlop() != null) {
            multiMatchQueryBuilder.slop(multiMatchQuery.getSlop().intValue());
        }
        if (multiMatchQuery.getType() != null) {
            MultiMatchQueryBuilder.Type multiMatchQueryBuilderType = this.translate(multiMatchQuery.getType());
            multiMatchQueryBuilder.type(multiMatchQueryBuilderType);
        }
        if (multiMatchQuery.getZeroTermsQuery() != null) {
            ZeroTermsQueryOption zeroTermsQueryOption = this.translate(multiMatchQuery.getZeroTermsQuery());
            multiMatchQueryBuilder.zeroTermsQuery(zeroTermsQueryOption);
        }
        if (multiMatchQuery.isLenient() != null) {
            multiMatchQueryBuilder.lenient(multiMatchQuery.isLenient().booleanValue());
        }
        return multiMatchQueryBuilder;
    }

    protected MultiMatchQueryBuilder.Type translate(MultiMatchQuery.Type multiMatchQueryType) {
        if (multiMatchQueryType == MultiMatchQuery.Type.BEST_FIELDS) {
            return MultiMatchQueryBuilder.Type.BEST_FIELDS;
        }
        if (multiMatchQueryType == MultiMatchQuery.Type.BOOL_PREFIX) {
            return MultiMatchQueryBuilder.Type.BOOL_PREFIX;
        }
        if (multiMatchQueryType == MultiMatchQuery.Type.CROSS_FIELDS) {
            return MultiMatchQueryBuilder.Type.CROSS_FIELDS;
        }
        if (multiMatchQueryType == MultiMatchQuery.Type.MOST_FIELDS) {
            return MultiMatchQueryBuilder.Type.MOST_FIELDS;
        }
        if (multiMatchQueryType == MultiMatchQuery.Type.PHRASE) {
            return MultiMatchQueryBuilder.Type.PHRASE;
        }
        if (multiMatchQueryType == MultiMatchQuery.Type.PHRASE_PREFIX) {
            return MultiMatchQueryBuilder.Type.PHRASE_PREFIX;
        }
        throw new IllegalArgumentException("Invalid multi match query type: " + multiMatchQueryType);
    }
}

