/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.logging;

import com.liferay.portal.kernel.log.Log;

public class ElasticsearchExceptionHandler {
    protected static final String INDEX_NOT_FOUND_EXCEPTION_MESSAGE = "type=index_not_found_exception";
    private final Log _log;
    private final boolean _logExceptionsOnly;

    public ElasticsearchExceptionHandler(Log log, boolean logExceptionsOnly) {
        this._log = log;
        this._logExceptionsOnly = logExceptionsOnly;
    }

    public <T extends Throwable> void handleDeleteDocumentException(T t) throws T {
        if (this._isIndexNotFound(t)) {
            if (this._log.isInfoEnabled()) {
                this._log.info(t, t);
            }
        } else {
            this.logOrThrow(t);
        }
    }

    public <T extends Throwable> void logOrThrow(T t) throws T {
        if (this._logExceptionsOnly) {
            this._log.error(t, t);
        } else if (this._logExceptionsOnly) {
            this._log.error(t, t);
        } else {
            throw t;
        }
    }

    private boolean _isIndexNotFound(Throwable throwable) {
        String message = throwable.getMessage();
        return message.contains(INDEX_NOT_FOUND_EXCEPTION_MESSAGE);
    }
}

