/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.information;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.configuration.ElasticsearchConnectionConfiguration;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationWrapper;
import com.liferay.portal.search.elasticsearch7.internal.configuration.OperationModeResolver;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnection;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.engine.ConnectionInformation;
import com.liferay.portal.search.engine.ConnectionInformationBuilder;
import com.liferay.portal.search.engine.ConnectionInformationBuilderFactory;
import com.liferay.portal.search.engine.NodeInformation;
import com.liferay.portal.search.engine.NodeInformationBuilder;
import com.liferay.portal.search.engine.NodeInformationBuilderFactory;
import com.liferay.portal.search.engine.SearchEngineInformation;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.cluster.ClusterRequest;
import com.liferay.portal.search.engine.adapter.cluster.HealthClusterRequest;
import com.liferay.portal.search.engine.adapter.cluster.HealthClusterResponse;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.Version;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SearchEngineInformation.class})
public class ElasticsearchSearchEngineInformation
implements SearchEngineInformation {
    @Reference
    protected ConfigurationAdmin configurationAdmin;
    @Reference
    protected ConnectionInformationBuilderFactory connectionInformationBuilderFactory;
    @Reference
    protected volatile ElasticsearchConfigurationWrapper elasticsearchConfigurationWrapper;
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;
    @Reference
    protected NodeInformationBuilderFactory nodeInformationBuilderFactory;
    @Reference
    protected OperationModeResolver operationModeResolver;
    @Reference
    protected SearchEngineAdapter searchEngineAdapter;
    private static final Log _log = LogFactoryUtil.getLog(ElasticsearchSearchEngineInformation.class);
    @Reference
    private JSONFactory _jsonFactory;

    public String getClientVersionString() {
        return Version.CURRENT.toString();
    }

    public List<ConnectionInformation> getConnectionInformationList() {
        LinkedList<ConnectionInformation> connectionInformationList;
        block4: {
            connectionInformationList = new LinkedList<ConnectionInformation>();
            ElasticsearchConnection elasticsearchConnection = this.elasticsearchConnectionManager.getElasticsearchConnection();
            this._addMainConnection(elasticsearchConnection, connectionInformationList);
            String filterString = String.format("(&(service.factoryPid=%s)(active=%s)", ElasticsearchConnectionConfiguration.class.getName(), true);
            if (this.operationModeResolver.isProductionModeEnabled() && !Validator.isBlank((String)this.elasticsearchConfigurationWrapper.remoteClusterConnectionId())) {
                filterString = filterString.concat(String.format("(!(connectionId=%s))", this.elasticsearchConfigurationWrapper.remoteClusterConnectionId()));
            }
            ElasticsearchConnection localClusterElasticsearchConnection = this.elasticsearchConnectionManager.getElasticsearchConnection(true);
            if (this.operationModeResolver.isProductionModeEnabled() && this.elasticsearchConnectionManager.isCrossClusterReplicationEnabled() && !elasticsearchConnection.equals(localClusterElasticsearchConnection)) {
                this._addCCRConnection(localClusterElasticsearchConnection, connectionInformationList);
                filterString = filterString.concat(String.format("(!(connectionId=%s))", localClusterElasticsearchConnection.getConnectionId()));
            }
            filterString = filterString.concat(")");
            try {
                this._addActiveConnections(filterString, connectionInformationList);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)"Unable to get active connections", (Throwable)exception);
            }
        }
        return connectionInformationList;
    }

    public String getNodesString() {
        try {
            String localClusterNodesString;
            String clusterNodesString = this._getClusterNodesString(this.elasticsearchConnectionManager.getRestHighLevelClient());
            if (this.operationModeResolver.isProductionModeEnabled() && this.elasticsearchConnectionManager.isCrossClusterReplicationEnabled() && !Validator.isBlank((String)(localClusterNodesString = this._getClusterNodesString(this.elasticsearchConnectionManager.getRestHighLevelClient(null, true))))) {
                clusterNodesString = StringBundler.concat((String[])new String[]{"Remote Cluster = ", clusterNodesString, ", Local Cluster = ", localClusterNodesString});
            }
            return clusterNodesString;
        }
        catch (Exception exception) {
            return exception.toString();
        }
    }

    public String getVendorString() {
        String vendor = "Elasticsearch";
        if (this.operationModeResolver.isDevelopmentModeEnabled()) {
            return vendor + " (Sidecar)";
        }
        return vendor;
    }

    private void _addActiveConnections(String filterString, List<ConnectionInformation> connectionInformationList) throws Exception {
        Object[] configurations = this.configurationAdmin.listConfigurations(filterString);
        if (ArrayUtil.isEmpty((Object[])configurations)) {
            return;
        }
        for (Object configuration : configurations) {
            Dictionary properties = configuration.getProperties();
            String connectionId = (String)properties.get("connectionId");
            this._addConnectionInformation(this.elasticsearchConnectionManager.getElasticsearchConnection(connectionId), connectionInformationList, null);
        }
    }

    private void _addCCRConnection(ElasticsearchConnection elasticsearchConnection, List<ConnectionInformation> connectionInformationList) {
        this._addConnectionInformation(elasticsearchConnection, connectionInformationList, "read");
    }

    private void _addConnectionInformation(ElasticsearchConnection elasticsearchConnection, List<ConnectionInformation> connectionInformationList, String ... labels) {
        ConnectionInformationBuilder connectionInformationBuilder;
        block7: {
            block6: {
                if (elasticsearchConnection == null) {
                    return;
                }
                connectionInformationBuilder = this.connectionInformationBuilderFactory.getConnectionInformationBuilder();
                try {
                    this._setClusterAndNodeInformation(connectionInformationBuilder, elasticsearchConnection.getRestHighLevelClient());
                }
                catch (Exception exception) {
                    connectionInformationBuilder.error(exception.toString());
                    if (!_log.isWarnEnabled()) break block6;
                    _log.warn((Object)"Unable to get node information", (Throwable)exception);
                }
            }
            connectionInformationBuilder.connectionId(elasticsearchConnection.getConnectionId());
            try {
                this._setHealthInformation(connectionInformationBuilder, elasticsearchConnection.getConnectionId());
            }
            catch (RuntimeException runtimeException) {
                connectionInformationBuilder.health("unknown");
                if (!_log.isWarnEnabled()) break block7;
                _log.warn((Object)"Unable to get health information", (Throwable)runtimeException);
            }
        }
        if (ArrayUtil.isNotEmpty((Object[])labels)) {
            connectionInformationBuilder.labels(SetUtil.fromArray((Object[])labels));
        }
        connectionInformationList.add(connectionInformationBuilder.build());
    }

    private void _addMainConnection(ElasticsearchConnection elasticsearchConnection, List<ConnectionInformation> connectionInformationList) {
        String[] labels = new String[]{"read", "write"};
        if (this.operationModeResolver.isProductionModeEnabled() && this.elasticsearchConnectionManager.isCrossClusterReplicationEnabled() && !elasticsearchConnection.equals(this.elasticsearchConnectionManager.getElasticsearchConnection(true))) {
            labels = new String[]{"write"};
        }
        this._addConnectionInformation(elasticsearchConnection, connectionInformationList, labels);
    }

    private String _getClusterNodesString(RestHighLevelClient restHighLevelClient) {
        try {
            if (restHighLevelClient == null) {
                return "";
            }
            ConnectionInformationBuilder connectionInformationBuilder = this.connectionInformationBuilderFactory.getConnectionInformationBuilder();
            this._setClusterAndNodeInformation(connectionInformationBuilder, restHighLevelClient);
            ConnectionInformation connectionInformation = connectionInformationBuilder.build();
            String clusterName = connectionInformation.getClusterName();
            List nodeInformations = connectionInformation.getNodeInformationList();
            Stream stream = nodeInformations.stream();
            return StringBundler.concat((String[])new String[]{clusterName, ":", " ", "[", stream.map(nodeInfo -> StringBundler.concat((String[])new String[]{nodeInfo.getName(), " ", "(", nodeInfo.getVersion(), ")"})).collect(Collectors.joining(", ")), "]"});
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to get node information", (Throwable)exception);
            }
            return StringBundler.concat((String[])new String[]{"(Error: ", exception.toString(), ")"});
        }
    }

    private void _setClusterAndNodeInformation(ConnectionInformationBuilder connectionInformationBuilder, RestHighLevelClient restHighLevelClient) throws Exception {
        RestClient restClient = restHighLevelClient.getLowLevelClient();
        String endpoint = "/_nodes";
        Request request = new Request("GET", endpoint);
        request.addParameter("timeout", "10000ms");
        Response response = restClient.performRequest(request);
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        JSONObject responseJSONObject = this._jsonFactory.createJSONObject(responseBody);
        String clusterName = GetterUtil.getString((Object)responseJSONObject.get("cluster_name"));
        connectionInformationBuilder.clusterName(clusterName);
        JSONObject nodesJSONObject = responseJSONObject.getJSONObject("nodes");
        Set nodes = nodesJSONObject.keySet();
        ArrayList<NodeInformation> nodeInformationList = new ArrayList<NodeInformation>();
        for (String node : nodes) {
            JSONObject nodeJSONObject = nodesJSONObject.getJSONObject(node);
            NodeInformationBuilder nodeInformationBuilder = this.nodeInformationBuilderFactory.getNodeInformationBuilder();
            nodeInformationBuilder.name(GetterUtil.getString((Object)nodeJSONObject.get("name")));
            nodeInformationBuilder.version(GetterUtil.getString((Object)nodeJSONObject.get("version")));
            nodeInformationList.add(nodeInformationBuilder.build());
        }
        connectionInformationBuilder.nodeInformationList(nodeInformationList);
    }

    private void _setHealthInformation(ConnectionInformationBuilder connectionInformationBuilder, String connectionId) {
        HealthClusterRequest healthClusterRequest = new HealthClusterRequest();
        healthClusterRequest.setConnectionId(connectionId);
        healthClusterRequest.setTimeout(1000L);
        HealthClusterResponse healthClusterResponse = (HealthClusterResponse)this.searchEngineAdapter.execute((ClusterRequest)healthClusterRequest);
        connectionInformationBuilder.health(String.valueOf(healthClusterResponse.getClusterHealthStatus()));
    }
}

