/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.index;

import com.liferay.portal.search.elasticsearch7.internal.util.ResourceUtil;
import com.liferay.portal.search.spi.index.IndexDefinition;
import java.util.Map;
import java.util.Objects;

public class IndexDefinitionData {
    private final String _index;
    private final String _source;

    public IndexDefinitionData(IndexDefinition indexDefinition, Map<String, Object> propertiesMap) {
        this._index = this._getIndexName(propertiesMap.get("index.name"));
        this._source = this._getSource(indexDefinition, propertiesMap.get("index.settings.resource.name"));
    }

    public String getIndex() {
        return this._index;
    }

    public String getSource() {
        return this._source;
    }

    private String _getIndexName(Object property) {
        return String.valueOf(Objects.requireNonNull(property));
    }

    private String _getSource(IndexDefinition indexDefinition, Object property) {
        String resourceName = String.valueOf(Objects.requireNonNull(property));
        return ResourceUtil.getResourceAsString(indexDefinition.getClass(), resourceName);
    }
}

