/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.index;

import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.index.IndexInformation;
import com.liferay.portal.search.index.IndexNameBuilder;
import java.io.IOException;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={IndexInformation.class})
public class ElasticsearchIndexInformation
implements IndexInformation {
    @Reference
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    @Reference
    private IndexNameBuilder _indexNameBuilder;

    public String getCompanyIndexName(long companyId) {
        return this._indexNameBuilder.getIndexName(companyId);
    }

    public String getFieldMappings(String indexName) {
        GetMappingsRequest getMappingsRequest = new GetMappingsRequest();
        getMappingsRequest.indices(new String[]{indexName});
        GetMappingsResponse getMappingsResponse = this.getMappingsResponse(getMappingsRequest);
        return Strings.toString((ToXContent)getMappingsResponse, (boolean)true, (boolean)true);
    }

    public String[] getIndexNames() {
        GetIndexRequest getIndexRequest = new GetIndexRequest(new String[]{"*"});
        GetIndexResponse getIndexResponse = this.getIndexResponse(getIndexRequest);
        return getIndexResponse.getIndices();
    }

    protected GetIndexResponse getIndexResponse(GetIndexRequest getIndexRequest) {
        IndicesClient indicesClient = this._getIndicesClient();
        try {
            return indicesClient.get(getIndexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected GetMappingsResponse getMappingsResponse(GetMappingsRequest getMappingsRequest) {
        IndicesClient indicesClient = this._getIndicesClient();
        try {
            return indicesClient.getMapping(getMappingsRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private IndicesClient _getIndicesClient() {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(null, true);
        return restHighLevelClient.indices();
    }
}

