/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.hits;

import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.document.DocumentBuilder;
import com.liferay.portal.search.document.DocumentBuilderFactory;
import com.liferay.portal.search.elasticsearch7.internal.document.DocumentFieldsTranslator;
import com.liferay.portal.search.geolocation.GeoBuilders;
import com.liferay.portal.search.highlight.HighlightField;
import com.liferay.portal.search.highlight.HighlightFieldBuilderFactory;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHitBuilder;
import com.liferay.portal.search.hits.SearchHitBuilderFactory;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.hits.SearchHitsBuilder;
import com.liferay.portal.search.hits.SearchHitsBuilderFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.common.text.Text;

public class SearchHitsTranslator {
    private final DocumentBuilderFactory _documentBuilderFactory;
    private final GeoBuilders _geoBuilders;
    private final HighlightFieldBuilderFactory _highlightFieldBuilderFactory;
    private final SearchHitBuilderFactory _searchHitBuilderFactory;
    private final SearchHitsBuilderFactory _searchHitsBuilderFactory;

    public SearchHitsTranslator(SearchHitBuilderFactory searchHitBuilderFactory, SearchHitsBuilderFactory searchHitsBuilderFactory, DocumentBuilderFactory documentBuilderFactory, HighlightFieldBuilderFactory highlightFieldBuilderFactory, GeoBuilders geoBuilders) {
        this._searchHitBuilderFactory = searchHitBuilderFactory;
        this._searchHitsBuilderFactory = searchHitsBuilderFactory;
        this._documentBuilderFactory = documentBuilderFactory;
        this._highlightFieldBuilderFactory = highlightFieldBuilderFactory;
        this._geoBuilders = geoBuilders;
    }

    public SearchHits translate(org.elasticsearch.search.SearchHits elasticsearchSearchHits) {
        return this.translate(elasticsearchSearchHits, null);
    }

    public SearchHits translate(org.elasticsearch.search.SearchHits elasticsearchSearchHits, String alternateUidFieldName) {
        SearchHitsBuilder searchHitsBuilder = this._searchHitsBuilderFactory.getSearchHitsBuilder();
        TotalHits totalHits = elasticsearchSearchHits.getTotalHits();
        org.elasticsearch.search.SearchHit[] elasticsearchSearchHitArray = elasticsearchSearchHits.getHits();
        ArrayList<SearchHit> searchHits = new ArrayList<SearchHit>(elasticsearchSearchHitArray.length);
        for (org.elasticsearch.search.SearchHit elasticsearchSearchHit : elasticsearchSearchHitArray) {
            searchHits.add(this.translate(elasticsearchSearchHit, alternateUidFieldName));
        }
        return searchHitsBuilder.addSearchHits(searchHits).maxScore(elasticsearchSearchHits.getMaxScore()).totalHits(totalHits.value).build();
    }

    protected SearchHit translate(org.elasticsearch.search.SearchHit elasticsearchSearchHit, String alternateUidFieldName) {
        SearchHitBuilder searchHitBuilder = this._searchHitBuilderFactory.getSearchHitBuilder();
        return searchHitBuilder.addHighlightFields(this._translateHighlightFields(elasticsearchSearchHit)).addSources(elasticsearchSearchHit.getSourceAsMap()).document(this._translateDocument(elasticsearchSearchHit, alternateUidFieldName)).explanation(this._getExplanationString(elasticsearchSearchHit)).id(elasticsearchSearchHit.getId()).matchedQueries(elasticsearchSearchHit.getMatchedQueries()).score(elasticsearchSearchHit.getScore()).version(elasticsearchSearchHit.getVersion()).build();
    }

    private String _getExplanationString(org.elasticsearch.search.SearchHit elasticsearchSearchHit) {
        Explanation explanation = elasticsearchSearchHit.getExplanation();
        if (explanation != null) {
            return explanation.toString();
        }
        return "";
    }

    private Document _translateDocument(org.elasticsearch.search.SearchHit elasticsearchSearchHit, String alternateUidFieldName) {
        DocumentFieldsTranslator documentFieldsTranslator = new DocumentFieldsTranslator(this._geoBuilders);
        DocumentBuilder documentBuilder = this._documentBuilderFactory.builder();
        Map documentSourceMap = elasticsearchSearchHit.getSourceAsMap();
        documentFieldsTranslator.translate(documentBuilder, documentSourceMap);
        Map documentFieldsMap = elasticsearchSearchHit.getFields();
        documentFieldsTranslator.translate(documentFieldsMap, documentBuilder);
        documentFieldsTranslator.populateAlternateUID(documentFieldsMap, documentBuilder, alternateUidFieldName);
        return documentBuilder.build();
    }

    private HighlightField _translateHighlightField(org.elasticsearch.search.fetch.subphase.highlight.HighlightField elasticsearchHighlightField) {
        return this._highlightFieldBuilderFactory.builder().fragments(Stream.of(elasticsearchHighlightField.getFragments()).map(Text::string)).name(elasticsearchHighlightField.getName()).build();
    }

    private List<HighlightField> _translateHighlightFields(org.elasticsearch.search.SearchHit elasticsearchSearchHit) {
        Map map = elasticsearchSearchHit.getHighlightFields();
        ArrayList<HighlightField> highlightFields = new ArrayList<HighlightField>();
        for (org.elasticsearch.search.fetch.subphase.highlight.HighlightField highlightField : map.values()) {
            highlightFields.add(this._translateHighlightField(highlightField));
        }
        return highlightFields;
    }
}

