/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.facet;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetProcessor;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetUtil;
import java.util.Optional;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"class.name=DEFAULT"}, service={FacetProcessor.class})
public class DefaultFacetProcessor
implements FacetProcessor<SearchRequestBuilder> {
    @Override
    public Optional<AggregationBuilder> processFacet(Facet facet) {
        int minDocCount;
        TermsAggregationBuilder termsAggregationBuilder = AggregationBuilders.terms((String)FacetUtil.getAggregationName(facet));
        termsAggregationBuilder.field(facet.getFieldName());
        FacetConfiguration facetConfiguration = facet.getFacetConfiguration();
        JSONObject dataJSONObject = facetConfiguration.getData();
        String include = dataJSONObject.getString("include", null);
        if (include != null) {
            termsAggregationBuilder.includeExclude(new IncludeExclude(include, null));
        }
        if ((minDocCount = dataJSONObject.getInt("frequencyThreshold")) > 0) {
            termsAggregationBuilder.minDocCount((long)minDocCount);
        }
        termsAggregationBuilder.order(BucketOrder.count((boolean)false));
        int size = dataJSONObject.getInt("maxTerms");
        if (size > 0) {
            termsAggregationBuilder.size(size);
        }
        return Optional.of(termsAggregationBuilder);
    }
}

