/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.connection;

import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchInstancePaths;
import java.nio.file.Path;
import java.util.Optional;

public class ElasticsearchInstancePathsBuilder {
    private Path _dataPath;
    private Path _homePath;
    private Path _workPath;

    public ElasticsearchInstancePaths build() {
        return new ElasticsearchInstancePathsImpl(this.toAbsolutePath(this._dataPath), this.toAbsolutePath(this._homePath), this.toAbsolutePath(this._workPath));
    }

    public ElasticsearchInstancePathsBuilder dataPath(Path dataHomePath) {
        this._dataPath = dataHomePath;
        return this;
    }

    public ElasticsearchInstancePathsBuilder homePath(Path homePath) {
        this._homePath = homePath;
        return this;
    }

    public ElasticsearchInstancePathsBuilder workPath(Path workPath) {
        this._workPath = workPath;
        return this;
    }

    protected Path toAbsolutePath(Path path) {
        return Optional.ofNullable(path).map(Path::toAbsolutePath).orElse(null);
    }

    private static class ElasticsearchInstancePathsImpl
    implements ElasticsearchInstancePaths {
        private final Path _dataPath;
        private final Path _homePath;
        private final Path _workPath;

        public ElasticsearchInstancePathsImpl(Path dataPath, Path homePath, Path workPath) {
            this._dataPath = dataPath;
            this._homePath = homePath;
            this._workPath = workPath;
        }

        @Override
        public Path getDataPath() {
            return this._dataPath;
        }

        @Override
        public Path getHomePath() {
            return this._homePath;
        }

        @Override
        public Path getWorkPath() {
            return this._workPath;
        }
    }
}

