/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.geolocation.GeoLocationPoint;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.elasticsearch7.internal.SearchHitDocumentTranslator;
import java.util.Collection;
import java.util.Map;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.search.SearchHit;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={SearchHitDocumentTranslator.class})
public class SearchHitDocumentTranslatorImpl
implements SearchHitDocumentTranslator {
    @Override
    public Document translate(SearchHit searchHit) {
        Map documentFields;
        DocumentImpl document = new DocumentImpl();
        Map documentSourceMap = searchHit.getSourceAsMap();
        if (MapUtil.isNotEmpty((Map)documentSourceMap)) {
            for (String fieldName : documentSourceMap.keySet()) {
                this._addFieldFromSource((Document)document, fieldName, documentSourceMap);
            }
        }
        if (MapUtil.isNotEmpty((Map)(documentFields = searchHit.getFields()))) {
            for (String fieldName : documentFields.keySet()) {
                if (document.getField(fieldName) != null) continue;
                this._addField((Document)document, fieldName, documentFields);
            }
        }
        return document;
    }

    protected Field translate(DocumentField documentField) {
        return this.translate(documentField.getName(), documentField.getValues());
    }

    protected Field translate(String fieldName, Object value) {
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            return new Field(fieldName, ArrayUtil.toStringArray((Object[])values.toArray(new Object[0])));
        }
        return new Field(fieldName, String.valueOf(value));
    }

    private void _addField(Document document, String fieldName, Map<String, DocumentField> documentFields) {
        Field field = this._getField(fieldName, documentFields);
        if (field != null) {
            document.add(field);
        }
    }

    private void _addFieldFromSource(Document document, String fieldName, Map<String, Object> documentSourceMap) {
        Field field = this._getFieldFromSource(fieldName, documentSourceMap);
        if (field != null) {
            document.add(field);
        }
    }

    private Field _getField(String fieldName, Map<String, DocumentField> documentFields) {
        if (this._isInvalidFieldName(fieldName)) {
            return null;
        }
        DocumentField documentField = documentFields.get(fieldName);
        if (documentFields.containsKey(fieldName.concat(".geopoint"))) {
            return this._translateGeoPoint(documentField);
        }
        return this.translate(documentField);
    }

    private Field _getFieldFromSource(String fieldName, Map<String, Object> documentSourceMap) {
        if (this._isInvalidFieldName(fieldName)) {
            return null;
        }
        Object value = documentSourceMap.get(fieldName);
        if (documentSourceMap.containsKey(fieldName.concat(".geopoint"))) {
            return this._translateGeoPoint(fieldName, value);
        }
        return this.translate(fieldName, value);
    }

    private boolean _isInvalidFieldName(String fieldName) {
        return fieldName.endsWith(".geopoint") || fieldName.equals("_ignored");
    }

    private Field _translateGeoPoint(DocumentField documentField) {
        return this._translateGeoPoint(documentField.getName(), documentField.getValue());
    }

    private Field _translateGeoPoint(String fieldName, Object value) {
        Field field = new Field(fieldName);
        String[] values = StringUtil.split((String)String.valueOf(value));
        field.setGeoLocationPoint(new GeoLocationPoint(Double.valueOf(values[0]).doubleValue(), Double.valueOf(values[1]).doubleValue()));
        return field;
    }
}

