/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search;

import com.liferay.portal.kernel.search.GroupBy;
import com.liferay.portal.kernel.search.Stats;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.groupby.GroupByTranslator;
import com.liferay.portal.search.elasticsearch7.internal.highlight.HighlightTranslator;
import com.liferay.portal.search.elasticsearch7.internal.highlight.HighlighterTranslator;
import com.liferay.portal.search.elasticsearch7.internal.query.QueryToQueryBuilderTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.CommonSearchRequestBuilderAssembler;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.SearchSearchRequestAssembler;
import com.liferay.portal.search.elasticsearch7.internal.sort.SortTranslator;
import com.liferay.portal.search.elasticsearch7.internal.stats.StatsTranslator;
import com.liferay.portal.search.engine.adapter.search.BaseSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.groupby.GroupByRequest;
import com.liferay.portal.search.legacy.groupby.GroupByRequestFactory;
import com.liferay.portal.search.legacy.stats.StatsRequestBuilderFactory;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortFieldTranslator;
import com.liferay.portal.search.stats.StatsRequest;
import com.liferay.portal.search.stats.StatsRequestBuilder;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SearchSearchRequestAssembler.class})
public class SearchSearchRequestAssemblerImpl
implements SearchSearchRequestAssembler {
    private CommonSearchRequestBuilderAssembler _commonSearchRequestBuilderAssembler;
    private GroupByRequestFactory _groupByRequestFactory;
    private GroupByTranslator _groupByTranslator;
    private HighlighterTranslator _highlighterTranslator;
    private final HighlightTranslator _highlightTranslator = new HighlightTranslator();
    private QueryToQueryBuilderTranslator _queryToQueryBuilderTranslator;
    private SortFieldTranslator<SortBuilder> _sortFieldTranslator;
    private SortTranslator _sortTranslator;
    private StatsRequestBuilderFactory _statsRequestBuilderFactory;
    private StatsTranslator _statsTranslator;

    @Override
    public void assemble(SearchRequestBuilder searchRequestBuilder, SearchSearchRequest searchSearchRequest) {
        this._commonSearchRequestBuilderAssembler.assemble(searchRequestBuilder, (BaseSearchRequest)searchSearchRequest);
        this.setFetchSource(searchRequestBuilder, searchSearchRequest);
        this.setGroupBy(searchRequestBuilder, searchSearchRequest);
        this.setGroupByRequests(searchRequestBuilder, searchSearchRequest);
        this.setHighlighter(searchRequestBuilder, searchSearchRequest);
        this.setPagination(searchRequestBuilder, searchSearchRequest);
        this.setPreference(searchRequestBuilder, searchSearchRequest);
        this.setSorts(searchRequestBuilder, searchSearchRequest);
        this.setStats(searchRequestBuilder, searchSearchRequest);
        this.setStoredFields(searchRequestBuilder, searchSearchRequest);
        this.setTrackScores(searchRequestBuilder, searchSearchRequest);
        this.setVersion(searchRequestBuilder, searchSearchRequest);
    }

    @Reference(unbind="-")
    protected void setCommonSearchRequestBuilderAssembler(CommonSearchRequestBuilderAssembler commonSearchRequestBuilderAssembler) {
        this._commonSearchRequestBuilderAssembler = commonSearchRequestBuilderAssembler;
    }

    protected void setFetchSource(SearchRequestBuilder searchRequestBuilder, SearchSearchRequest searchSearchRequest) {
        if (searchSearchRequest.getFetchSource() != null || searchSearchRequest.getFetchSourceExcludes() != null || searchSearchRequest.getFetchSourceIncludes() != null) {
            if (searchSearchRequest.getFetchSource() == null) {
                searchRequestBuilder.setFetchSource(true);
            } else {
                searchRequestBuilder.setFetchSource(searchSearchRequest.getFetchSource().booleanValue());
            }
            searchRequestBuilder.setFetchSource(searchSearchRequest.getFetchSourceIncludes(), searchSearchRequest.getFetchSourceExcludes());
        }
    }

    protected void setGroupBy(SearchRequestBuilder searchRequestBuilder, SearchSearchRequest searchSearchRequest) {
        if (searchSearchRequest.getGroupBy() != null) {
            this._groupByTranslator.translate(searchRequestBuilder, this.translate(searchSearchRequest.getGroupBy()), searchSearchRequest.getLocale(), searchSearchRequest.getSelectedFieldNames(), searchSearchRequest.getHighlightFieldNames(), searchSearchRequest.isHighlightEnabled(), searchSearchRequest.isHighlightRequireFieldMatch(), searchSearchRequest.getHighlightFragmentSize(), searchSearchRequest.getHighlightSnippetSize());
        }
    }

    @Reference(unbind="-")
    protected void setGroupByRequestFactory(GroupByRequestFactory groupByRequestFactory) {
        this._groupByRequestFactory = groupByRequestFactory;
    }

    protected void setGroupByRequests(SearchRequestBuilder searchRequestBuilder, SearchSearchRequest searchSearchRequest) {
        List groupByRequests = searchSearchRequest.getGroupByRequests();
        if (ListUtil.isNotEmpty((List)groupByRequests)) {
            groupByRequests.forEach(groupByRequest -> this._groupByTranslator.translate(searchRequestBuilder, (GroupByRequest)groupByRequest, searchSearchRequest.getLocale(), searchSearchRequest.getSelectedFieldNames(), searchSearchRequest.getHighlightFieldNames(), searchSearchRequest.isHighlightEnabled(), searchSearchRequest.isHighlightRequireFieldMatch(), searchSearchRequest.getHighlightFragmentSize(), searchSearchRequest.getHighlightSnippetSize()));
        }
    }

    @Reference(unbind="-")
    protected void setGroupByTranslator(GroupByTranslator groupByTranslator) {
        this._groupByTranslator = groupByTranslator;
    }

    protected void setHighlighter(SearchRequestBuilder searchRequestBuilder, SearchSearchRequest searchSearchRequest) {
        if (searchSearchRequest.getHighlight() != null) {
            searchRequestBuilder.highlighter(this._highlightTranslator.translate(searchSearchRequest.getHighlight(), this._queryToQueryBuilderTranslator));
        } else if (searchSearchRequest.isHighlightEnabled()) {
            this._highlighterTranslator.translate(searchRequestBuilder, searchSearchRequest.getHighlightFieldNames(), searchSearchRequest.isHighlightRequireFieldMatch(), searchSearchRequest.getHighlightFragmentSize(), searchSearchRequest.getHighlightSnippetSize(), searchSearchRequest.isLuceneSyntax());
        }
    }

    @Reference(unbind="-")
    protected void setHighlighterTranslator(HighlighterTranslator highlighterTranslator) {
        this._highlighterTranslator = highlighterTranslator;
    }

    protected void setPagination(SearchRequestBuilder searchRequestBuilder, SearchSearchRequest searchSearchRequest) {
        if (searchSearchRequest.isSizeSet()) {
            searchRequestBuilder.setFrom(searchSearchRequest.getStart());
        }
        if (searchSearchRequest.isSizeSet()) {
            searchRequestBuilder.setSize(searchSearchRequest.getSize());
        }
    }

    protected void setPreference(SearchRequestBuilder searchRequestBuilder, SearchSearchRequest searchSearchRequest) {
        String preference = searchSearchRequest.getPreference();
        if (!Validator.isBlank((String)preference)) {
            searchRequestBuilder.setPreference(preference);
        }
    }

    @Reference(unbind="-")
    protected void setQueryToQueryBuilderTranslator(QueryToQueryBuilderTranslator queryToQueryBuilderTranslator) {
        this._queryToQueryBuilderTranslator = queryToQueryBuilderTranslator;
    }

    @Reference(unbind="-")
    protected void setSortFieldTranslator(SortFieldTranslator<SortBuilder> sortFieldTranslator) {
        this._sortFieldTranslator = sortFieldTranslator;
    }

    protected void setSorts(SearchRequestBuilder searchRequestBuilder, SearchSearchRequest searchSearchRequest) {
        for (Sort sort : searchSearchRequest.getSorts72()) {
            searchRequestBuilder.addSort((SortBuilder)this._sortFieldTranslator.translate(sort));
        }
        this._sortTranslator.translate(searchRequestBuilder, searchSearchRequest.getSorts());
    }

    @Reference(unbind="-")
    protected void setSortTranslator(SortTranslator sortTranslator) {
        this._sortTranslator = sortTranslator;
    }

    protected void setStats(SearchRequestBuilder searchRequestBuilder, SearchSearchRequest searchSearchRequest) {
        Map statsMap = searchSearchRequest.getStats();
        if (!MapUtil.isEmpty((Map)statsMap)) {
            statsMap.forEach((key, stats) -> this._statsTranslator.populateRequest(searchRequestBuilder, this.translate((Stats)stats)));
        }
    }

    @Reference(unbind="-")
    protected void setStatsRequestBuilderFactory(StatsRequestBuilderFactory statsRequestBuilderFactory) {
        this._statsRequestBuilderFactory = statsRequestBuilderFactory;
    }

    @Reference(unbind="-")
    protected void setStatsTranslator(StatsTranslator statsTranslator) {
        this._statsTranslator = statsTranslator;
    }

    protected void setStoredFields(SearchRequestBuilder searchRequestBuilder, SearchSearchRequest searchSearchRequest) {
        Object[] selectedFieldNames = searchSearchRequest.getSelectedFieldNames();
        if (!ArrayUtil.isEmpty((Object[])selectedFieldNames)) {
            searchRequestBuilder.storedFields((String[])selectedFieldNames);
        } else {
            searchRequestBuilder.addStoredField("*");
        }
    }

    protected void setTrackScores(SearchRequestBuilder searchRequestBuilder, SearchSearchRequest searchSearchRequest) {
        if (searchSearchRequest.getScoreEnabled() != null) {
            searchRequestBuilder.setTrackScores(searchSearchRequest.getScoreEnabled().booleanValue());
        }
    }

    protected void setVersion(SearchRequestBuilder searchRequestBuilder, SearchSearchRequest searchSearchRequest) {
        if (searchSearchRequest.getVersion() != null) {
            searchRequestBuilder.setVersion(searchSearchRequest.getVersion().booleanValue());
        }
    }

    protected GroupByRequest translate(GroupBy groupBy) {
        return this._groupByRequestFactory.getGroupByRequest(groupBy);
    }

    protected StatsRequest translate(Stats stats) {
        StatsRequestBuilder statsRequestBuilder = this._statsRequestBuilderFactory.getStatsRequestBuilder(stats);
        return statsRequestBuilder.build();
    }
}

