/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search;

import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.FilterTranslator;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.search.aggregation.AggregationTranslator;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregationTranslator;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetTranslator;
import com.liferay.portal.search.elasticsearch7.internal.filter.FilterToQueryBuilderTranslator;
import com.liferay.portal.search.elasticsearch7.internal.query.QueryToQueryBuilderTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.CommonSearchRequestBuilderAssembler;
import com.liferay.portal.search.elasticsearch7.internal.stats.StatsTranslator;
import com.liferay.portal.search.engine.adapter.search.BaseSearchRequest;
import com.liferay.portal.search.filter.ComplexQueryBuilderFactory;
import com.liferay.portal.search.filter.ComplexQueryPart;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.rescore.Rescore;
import com.liferay.portal.search.stats.StatsRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.rescore.QueryRescorerBuilder;
import org.elasticsearch.search.rescore.RescorerBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommonSearchRequestBuilderAssembler.class})
public class CommonSearchRequestBuilderAssemblerImpl
implements CommonSearchRequestBuilderAssembler {
    private AggregationTranslator<AggregationBuilder> _aggregationTranslator;
    private ComplexQueryBuilderFactory _complexQueryBuilderFactory;
    private FacetTranslator _facetTranslator;
    private FilterTranslator<QueryBuilder> _filterToQueryBuilderTranslator;
    private com.liferay.portal.search.elasticsearch7.internal.legacy.query.QueryToQueryBuilderTranslator _legacyQueryToQueryBuilderTranslator;
    private PipelineAggregationTranslator<PipelineAggregationBuilder> _pipelineAggregationTranslator;
    private QueryToQueryBuilderTranslator _queryToQueryBuilderTranslator;
    private StatsTranslator _statsTranslator;

    @Override
    public void assemble(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        this.setAggregations(searchRequestBuilder, baseSearchRequest);
        this.setExplain(searchRequestBuilder, baseSearchRequest);
        this.setFacets(searchRequestBuilder, baseSearchRequest);
        this.setIndexBoosts(searchRequestBuilder, baseSearchRequest);
        this.setIndices(searchRequestBuilder, baseSearchRequest);
        this.setMinScore(searchRequestBuilder, baseSearchRequest);
        this.setPipelineAggregations(searchRequestBuilder, baseSearchRequest);
        this.setPostFilter(searchRequestBuilder, baseSearchRequest);
        this.setQuery(searchRequestBuilder, baseSearchRequest);
        this.setRequestCache(searchRequestBuilder, baseSearchRequest);
        this.setRescorer(searchRequestBuilder, baseSearchRequest);
        this.setStatsRequests(searchRequestBuilder, baseSearchRequest);
        this.setTimeout(searchRequestBuilder, baseSearchRequest);
        this.setTrackTotalHits(searchRequestBuilder, baseSearchRequest);
        this.setTypes(searchRequestBuilder, baseSearchRequest);
    }

    protected com.liferay.portal.search.query.BooleanQuery buildComplexQuery(List<ComplexQueryPart> complexQueryParts) {
        return (com.liferay.portal.search.query.BooleanQuery)this._complexQueryBuilderFactory.builder().addParts(complexQueryParts).build();
    }

    protected QueryBuilder combine(BoolQueryBuilder boolQueryBuilder, QueryBuilder queryBuilder, BiConsumer<BoolQueryBuilder, QueryBuilder> biConsumer) {
        if (boolQueryBuilder == null) {
            return queryBuilder;
        }
        if (queryBuilder != null) {
            biConsumer.accept(boolQueryBuilder, queryBuilder);
        }
        return boolQueryBuilder;
    }

    protected QueryBuilder combine(QueryBuilder queryBuilder1, QueryBuilder queryBuilder2) {
        if (queryBuilder1 == null) {
            return queryBuilder2;
        }
        if (queryBuilder2 == null) {
            return queryBuilder1;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        return boolQueryBuilder.must(queryBuilder1).must(queryBuilder2);
    }

    protected void copy(List<Query> clauses, Consumer<QueryBuilder> consumer) {
        for (Query query : clauses) {
            consumer.accept(this.translateQuery(query));
        }
    }

    protected QueryBuilder getQueryBuilder(BaseSearchRequest baseSearchRequest) {
        QueryBuilder queryBuilder1 = this.combine(this.translateQuery(baseSearchRequest.getQuery72()), this.translateQuery(baseSearchRequest.getQuery()));
        List complexQueryParts = baseSearchRequest.getComplexQueryParts();
        if (complexQueryParts.isEmpty()) {
            QueryBuilder queryBuilder2 = this.combine(this.translate(Collections.emptyList()), queryBuilder1, BoolQueryBuilder::must);
            return this.combine(this.translate(Collections.emptyList()), queryBuilder2, BoolQueryBuilder::should);
        }
        ArrayList<ComplexQueryPart> additiveComplexQueryParts = new ArrayList<ComplexQueryPart>();
        ArrayList<ComplexQueryPart> noneAdditiveComplexQueryParts = new ArrayList<ComplexQueryPart>();
        for (ComplexQueryPart complexQueryPart : complexQueryParts) {
            if (complexQueryPart.isAdditive()) {
                additiveComplexQueryParts.add(complexQueryPart);
                continue;
            }
            noneAdditiveComplexQueryParts.add(complexQueryPart);
        }
        QueryBuilder queryBuilder2 = this.combine(this.translate(noneAdditiveComplexQueryParts), queryBuilder1, BoolQueryBuilder::must);
        return this.combine(this.translate(additiveComplexQueryParts), queryBuilder2, BoolQueryBuilder::should);
    }

    protected void setAggregations(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        Map aggregationsMap = baseSearchRequest.getAggregationsMap();
        if (MapUtil.isNotEmpty((Map)aggregationsMap)) {
            Collection aggregations = aggregationsMap.values();
            aggregations.forEach(aggregation -> {
                AggregationBuilder aggregationBuilder = (AggregationBuilder)this._aggregationTranslator.translate(aggregation);
                searchRequestBuilder.addAggregation(aggregationBuilder);
            });
        }
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    protected void setAggregationTranslator(AggregationTranslator<AggregationBuilder> aggregationTranslator) {
        this._aggregationTranslator = aggregationTranslator;
    }

    @Reference(unbind="-")
    protected void setComplexQueryBuilderFactory(ComplexQueryBuilderFactory complexQueryBuilderFactory) {
        this._complexQueryBuilderFactory = complexQueryBuilderFactory;
    }

    protected void setExplain(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        if (baseSearchRequest.getExplain() != null) {
            searchRequestBuilder.setExplain(baseSearchRequest.getExplain().booleanValue());
        }
    }

    protected void setFacets(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        this._facetTranslator.translate(searchRequestBuilder, baseSearchRequest.getQuery(), baseSearchRequest.getFacets(), baseSearchRequest.isBasicFacetSelection());
    }

    @Reference(unbind="-")
    protected void setFacetTranslator(FacetTranslator facetTranslator) {
        this._facetTranslator = facetTranslator;
    }

    @Reference(unbind="-")
    protected void setFilterToQueryBuilderTranslator(FilterToQueryBuilderTranslator filterToQueryBuilderTranslator) {
        this._filterToQueryBuilderTranslator = filterToQueryBuilderTranslator;
    }

    protected void setIndexBoosts(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        Map indexBoosts = baseSearchRequest.getIndexBoosts();
        if (MapUtil.isNotEmpty((Map)indexBoosts)) {
            indexBoosts.forEach((arg_0, arg_1) -> ((SearchRequestBuilder)searchRequestBuilder).addIndexBoost(arg_0, arg_1));
        }
    }

    protected void setIndices(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        searchRequestBuilder.setIndices(baseSearchRequest.getIndexNames());
    }

    @Reference(unbind="-")
    protected void setLegacyQueryToQueryBuilderTranslator(com.liferay.portal.search.elasticsearch7.internal.legacy.query.QueryToQueryBuilderTranslator queryToQueryBuilderTranslator) {
        this._legacyQueryToQueryBuilderTranslator = queryToQueryBuilderTranslator;
    }

    protected void setMinScore(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        if (baseSearchRequest.getMinimumScore() > 0.0f) {
            searchRequestBuilder.setMinScore(baseSearchRequest.getMinimumScore());
        }
    }

    protected void setPipelineAggregations(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        Map pipelineAggregationsMap = baseSearchRequest.getPipelineAggregationsMap();
        if (MapUtil.isNotEmpty((Map)pipelineAggregationsMap)) {
            Collection pipelineAggregations = pipelineAggregationsMap.values();
            pipelineAggregations.forEach(pipelineAggregation -> {
                PipelineAggregationBuilder pipelineAggregationBuilder = (PipelineAggregationBuilder)this._pipelineAggregationTranslator.translate(pipelineAggregation);
                searchRequestBuilder.addAggregation(pipelineAggregationBuilder);
            });
        }
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    protected void setPipelineAggregationTranslator(PipelineAggregationTranslator<PipelineAggregationBuilder> pipelineAggregationTranslator) {
        this._pipelineAggregationTranslator = pipelineAggregationTranslator;
    }

    protected void setPostFilter(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        if (baseSearchRequest.getPostFilterQuery() != null) {
            searchRequestBuilder.setPostFilter(this._queryToQueryBuilderTranslator.translate(baseSearchRequest.getPostFilterQuery()));
        } else if (baseSearchRequest.getPostFilter() != null) {
            searchRequestBuilder.setPostFilter((QueryBuilder)this._filterToQueryBuilderTranslator.translate(baseSearchRequest.getPostFilter(), null));
        }
    }

    protected void setQuery(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        searchRequestBuilder.setQuery(this.getQueryBuilder(baseSearchRequest));
    }

    @Reference(unbind="-")
    protected void setQueryToQueryBuilderTranslator(QueryToQueryBuilderTranslator queryToQueryBuilderTranslator) {
        this._queryToQueryBuilderTranslator = queryToQueryBuilderTranslator;
    }

    protected void setRequestCache(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        if (baseSearchRequest.getRequestCache() != null) {
            searchRequestBuilder.setRequestCache(baseSearchRequest.getRequestCache());
        }
    }

    protected void setRescorer(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        this.setRescorers(searchRequestBuilder, baseSearchRequest.getRescores());
        this.setRescorerQuery(searchRequestBuilder, baseSearchRequest.getRescoreQuery());
    }

    protected void setRescorerQuery(SearchRequestBuilder searchRequestBuilder, Query query) {
        if (query == null) {
            return;
        }
        searchRequestBuilder.addRescorer((RescorerBuilder)new QueryRescorerBuilder(this._queryToQueryBuilderTranslator.translate(query)));
    }

    protected void setRescorers(SearchRequestBuilder searchRequestBuilder, List<Rescore> rescores) {
        if (rescores == null) {
            return;
        }
        for (Rescore rescore : rescores) {
            QueryRescorerBuilder queryRescorerBuilder = new QueryRescorerBuilder(this._queryToQueryBuilderTranslator.translate(rescore.getQuery()));
            queryRescorerBuilder.windowSize(rescore.getWindowSize().intValue());
            searchRequestBuilder.addRescorer((RescorerBuilder)queryRescorerBuilder);
        }
    }

    protected void setStatsRequests(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        List statsRequests = baseSearchRequest.getStatsRequests();
        if (!ListUtil.isEmpty((List)statsRequests)) {
            statsRequests.forEach(statsRequest -> this._statsTranslator.populateRequest(searchRequestBuilder, (StatsRequest)statsRequest));
        }
    }

    @Reference(unbind="-")
    protected void setStatsTranslator(StatsTranslator statsTranslator) {
        this._statsTranslator = statsTranslator;
    }

    protected void setTimeout(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        if (baseSearchRequest.getTimeoutInMilliseconds() > 0L) {
            searchRequestBuilder.setTimeout(TimeValue.timeValueMillis((long)baseSearchRequest.getTimeoutInMilliseconds()));
        }
    }

    protected void setTrackTotalHits(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        if (baseSearchRequest.getTrackTotalHits()) {
            searchRequestBuilder.setTrackTotalHits(baseSearchRequest.getTrackTotalHits());
        }
    }

    protected void setTypes(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        if (baseSearchRequest.getTypes() != null) {
            searchRequestBuilder.setTypes(baseSearchRequest.getTypes());
        }
    }

    protected void transfer(com.liferay.portal.search.query.BooleanQuery booleanQuery, BoolQueryBuilder boolQueryBuilder) {
        this.copy(booleanQuery.getFilterQueryClauses(), arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).filter(arg_0));
        this.copy(booleanQuery.getMustNotQueryClauses(), arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).mustNot(arg_0));
        this.copy(booleanQuery.getMustQueryClauses(), arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).must(arg_0));
        this.copy(booleanQuery.getShouldQueryClauses(), arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).should(arg_0));
    }

    protected BoolQueryBuilder translate(List<ComplexQueryPart> complexQueryParts) {
        if (ListUtil.isEmpty(complexQueryParts)) {
            return null;
        }
        com.liferay.portal.search.query.BooleanQuery booleanQuery = this.buildComplexQuery(complexQueryParts);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        this.transfer(booleanQuery, boolQueryBuilder);
        return boolQueryBuilder;
    }

    protected QueryBuilder translateQuery(com.liferay.portal.kernel.search.Query query) {
        if (query == null) {
            return null;
        }
        QueryBuilder queryBuilder = this._legacyQueryToQueryBuilderTranslator.translate(query, null);
        if (query.getPreBooleanFilter() == null || query instanceof BooleanQuery) {
            return queryBuilder;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.filter((QueryBuilder)this._filterToQueryBuilderTranslator.translate((Filter)query.getPreBooleanFilter(), null));
        boolQueryBuilder.must(queryBuilder);
        return boolQueryBuilder;
    }

    protected QueryBuilder translateQuery(Query query) {
        if (query != null) {
            return this._queryToQueryBuilderTranslator.translate(query);
        }
        return null;
    }
}

