/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.FlushIndexRequestExecutor;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.IndexRequestShardFailureTranslator;
import com.liferay.portal.search.engine.adapter.index.FlushIndexRequest;
import com.liferay.portal.search.engine.adapter.index.FlushIndexResponse;
import com.liferay.portal.search.engine.adapter.index.IndexRequestShardFailure;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.admin.indices.flush.FlushAction;
import org.elasticsearch.action.admin.indices.flush.FlushRequestBuilder;
import org.elasticsearch.action.admin.indices.flush.FlushResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.rest.RestStatus;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FlushIndexRequestExecutor.class})
public class FlushIndexRequestExecutorImpl
implements FlushIndexRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    private IndexRequestShardFailureTranslator _indexRequestShardFailureTranslator;

    @Override
    public FlushIndexResponse execute(FlushIndexRequest flushIndexRequest) {
        FlushRequestBuilder flushRequestBuilder = this.createFlushRequestBuilder(flushIndexRequest);
        FlushResponse flushResponse = (FlushResponse)flushRequestBuilder.get();
        FlushIndexResponse flushIndexResponse = new FlushIndexResponse();
        flushIndexResponse.setFailedShards(flushResponse.getFailedShards());
        flushIndexResponse.setSuccessfulShards(flushResponse.getSuccessfulShards());
        flushIndexResponse.setTotalShards(flushResponse.getTotalShards());
        RestStatus restStatus = flushResponse.getStatus();
        flushIndexResponse.setRestStatus(restStatus.getStatus());
        Object[] shardOperationFailedExceptions = flushResponse.getShardFailures();
        if (ArrayUtil.isNotEmpty((Object[])shardOperationFailedExceptions)) {
            for (Object shardOperationFailedException : shardOperationFailedExceptions) {
                IndexRequestShardFailure indexRequestShardFailure = this._indexRequestShardFailureTranslator.translate((ShardOperationFailedException)shardOperationFailedException);
                flushIndexResponse.addIndexRequestShardFailure(indexRequestShardFailure);
            }
        }
        return flushIndexResponse;
    }

    protected FlushRequestBuilder createFlushRequestBuilder(FlushIndexRequest flushIndexRequest) {
        FlushRequestBuilder flushRequestBuilder = new FlushRequestBuilder((ElasticsearchClient)this._elasticsearchClientResolver.getClient(false), FlushAction.INSTANCE);
        flushRequestBuilder.setIndices(flushIndexRequest.getIndexNames());
        flushRequestBuilder.setForce(flushIndexRequest.isForce());
        flushRequestBuilder.setWaitIfOngoing(flushIndexRequest.isWaitIfOngoing());
        return flushRequestBuilder;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }

    @Reference(unbind="-")
    protected void setIndexRequestShardFailureTranslator(IndexRequestShardFailureTranslator indexRequestShardFailureTranslator) {
        this._indexRequestShardFailureTranslator = indexRequestShardFailureTranslator;
    }
}

