/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.query.QueryTranslator;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document.UpdateByQueryDocumentRequestExecutor;
import com.liferay.portal.search.engine.adapter.document.UpdateByQueryDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateByQueryDocumentResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.UpdateByQueryAction;
import org.elasticsearch.index.reindex.UpdateByQueryRequestBuilder;
import org.elasticsearch.script.Script;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={UpdateByQueryDocumentRequestExecutor.class})
public class UpdateByQueryDocumentRequestExecutorImpl
implements UpdateByQueryDocumentRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    private QueryTranslator<QueryBuilder> _queryTranslator;

    @Override
    public UpdateByQueryDocumentResponse execute(UpdateByQueryDocumentRequest updateByQueryDocumentRequest) {
        UpdateByQueryRequestBuilder updateByQueryRequestBuilder = this.createUpdateByQueryRequestBuilder(updateByQueryDocumentRequest);
        BulkByScrollResponse bulkByScrollResponse = (BulkByScrollResponse)updateByQueryRequestBuilder.get();
        TimeValue timeValue = bulkByScrollResponse.getTook();
        return new UpdateByQueryDocumentResponse(bulkByScrollResponse.getUpdated(), timeValue.getMillis());
    }

    protected UpdateByQueryRequestBuilder createUpdateByQueryRequestBuilder(UpdateByQueryDocumentRequest updateByQueryDocumentRequest) {
        UpdateByQueryRequestBuilder updateByQueryRequestBuilder = new UpdateByQueryRequestBuilder((ElasticsearchClient)this._elasticsearchClientResolver.getClient(false), (ActionType)UpdateByQueryAction.INSTANCE);
        QueryBuilder queryBuilder = (QueryBuilder)this._queryTranslator.translate(updateByQueryDocumentRequest.getQuery(), null);
        updateByQueryRequestBuilder.filter(queryBuilder);
        updateByQueryRequestBuilder.refresh(updateByQueryDocumentRequest.isRefresh());
        JSONObject jsonObject = updateByQueryDocumentRequest.getScriptJSONObject();
        if (jsonObject != null) {
            Script script = new Script(jsonObject.toString());
            updateByQueryRequestBuilder.script(script);
        }
        updateByQueryRequestBuilder.source(updateByQueryDocumentRequest.getIndexNames());
        return updateByQueryRequestBuilder;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    protected void setQueryTranslator(QueryTranslator<QueryBuilder> queryTranslator) {
        this._queryTranslator = queryTranslator;
    }
}

