/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.information;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.configuration.CrossClusterReplicationConfigurationWrapper;
import com.liferay.portal.search.elasticsearch7.configuration.ElasticsearchConfiguration;
import com.liferay.portal.search.elasticsearch7.configuration.OperationMode;
import com.liferay.portal.search.elasticsearch7.internal.ElasticsearchSearchEngine;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnection;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.cluster.ClusterHealthStatusTranslator;
import com.liferay.portal.search.engine.ConnectionInformation;
import com.liferay.portal.search.engine.ConnectionInformationBuilder;
import com.liferay.portal.search.engine.ConnectionInformationBuilderFactory;
import com.liferay.portal.search.engine.NodeInformation;
import com.liferay.portal.search.engine.NodeInformationBuilder;
import com.liferay.portal.search.engine.NodeInformationBuilderFactory;
import com.liferay.portal.search.engine.SearchEngineInformation;
import com.liferay.portal.search.engine.adapter.cluster.ClusterHealthStatus;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequestBuilder;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.unit.TimeValue;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(configurationPid={"com.liferay.portal.search.elasticsearch7.configuration.ElasticsearchConfiguration"}, immediate=true, service={SearchEngineInformation.class})
public class ElasticsearchSearchEngineInformation
implements SearchEngineInformation {
    @Reference
    protected ClusterHealthStatusTranslator clusterHealthStatusTranslator;
    @Reference
    protected ConfigurationAdmin configurationAdmin;
    @Reference
    protected ConnectionInformationBuilderFactory connectionInformationBuilderFactory;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    protected volatile CrossClusterReplicationConfigurationWrapper crossClusterReplicationConfigurationWrapper;
    protected volatile ElasticsearchConfiguration elasticsearchConfiguration;
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;
    @Reference
    protected ElasticsearchSearchEngine elasticsearchSearchEngine;
    @Reference
    protected NodeInformationBuilderFactory nodeInformationBuilderFactory;
    private static final String _ELASTICSEARCH_CONNECTION_CONFIGURATION_CLASS_NAME = "com.liferay.portal.search.elasticsearch.cross.cluster.replication.internal.configuration.ElasticsearchConnectionConfiguration";
    private static final Log _log = LogFactoryUtil.getLog(ElasticsearchSearchEngineInformation.class);

    public String getClientVersionString() {
        return Version.CURRENT.toString();
    }

    public List<ConnectionInformation> getConnectionInformationList() {
        LinkedList<ConnectionInformation> connectionInformationList;
        block4: {
            if (!this.isCrossClusterReplicationInstalled()) {
                return null;
            }
            connectionInformationList = new LinkedList<ConnectionInformation>();
            ElasticsearchConnection elasticsearchConnection = this.elasticsearchConnectionManager.getElasticsearchConnection();
            this.addMainConnection(elasticsearchConnection, connectionInformationList);
            String filterString = String.format("(&(service.factoryPid=%s)", _ELASTICSEARCH_CONNECTION_CONFIGURATION_CLASS_NAME);
            ElasticsearchConnection localClusterElasticsearchConnection = this.elasticsearchConnectionManager.getElasticsearchConnection(true);
            if (!this.isOperationModeEmbedded() && this.elasticsearchConnectionManager.isCrossClusterReplicationEnabled() && !elasticsearchConnection.equals(localClusterElasticsearchConnection)) {
                this.addCCRConnection(localClusterElasticsearchConnection, connectionInformationList);
                filterString = filterString.concat(String.format("(!(connectionId=%s))", localClusterElasticsearchConnection.getConnectionId()));
            }
            filterString = filterString.concat(")");
            try {
                this.addActiveConnections(filterString, connectionInformationList);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)"Unable to get active connections", (Throwable)exception);
            }
        }
        return connectionInformationList;
    }

    public String getNodesString() {
        try {
            String localClusterNodesString;
            String clusterNodesString = this.getClusterNodesString(this.elasticsearchConnectionManager.getClient());
            if (!this.isOperationModeEmbedded() && this.elasticsearchConnectionManager.isCrossClusterReplicationEnabled() && !Validator.isBlank((String)(localClusterNodesString = this.getClusterNodesString(this.elasticsearchConnectionManager.getClient(true))))) {
                StringBundler sb = new StringBundler(11);
                sb.append("Remote Cluster");
                sb.append(" ");
                sb.append("=");
                sb.append(" ");
                sb.append(clusterNodesString);
                sb.append(", ");
                sb.append("Local Cluster");
                sb.append(" ");
                sb.append("=");
                sb.append(" ");
                sb.append(localClusterNodesString);
                clusterNodesString = sb.toString();
            }
            return clusterNodesString;
        }
        catch (Exception exception) {
            return exception.toString();
        }
    }

    @Deprecated
    public String getStatusString() {
        StringBundler sb = new StringBundler(8);
        sb.append("Vendor: ");
        sb.append(this.getVendorString());
        sb.append(", ");
        sb.append("Client Version: ");
        sb.append(this.getClientVersionString());
        sb.append(", ");
        sb.append("Nodes: ");
        sb.append(this.getNodesString());
        return sb.toString();
    }

    public String getVendorString() {
        String vendor = this.elasticsearchSearchEngine.getVendor();
        if (this.isOperationModeEmbedded()) {
            StringBundler sb = new StringBundler(5);
            sb.append(vendor);
            sb.append(" ");
            sb.append("(");
            sb.append("Embedded");
            sb.append(")");
            return sb.toString();
        }
        return vendor;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this.elasticsearchConfiguration = (ElasticsearchConfiguration)ConfigurableUtil.createConfigurable(ElasticsearchConfiguration.class, properties);
    }

    protected void addActiveConnections(String filterString, List<ConnectionInformation> connectionInformationList) throws Exception {
        Configuration[] configurations;
        for (Configuration configuration : configurations = this.configurationAdmin.listConfigurations(filterString)) {
            Dictionary properties = configuration.getProperties();
            String connectionId = (String)properties.get("connectionId");
            this.addConnectionInformation(this.elasticsearchConnectionManager.getCCRElasticsearchConnection(connectionId), connectionInformationList, null);
        }
    }

    protected void addCCRConnection(ElasticsearchConnection elasticsearchConnection, List<ConnectionInformation> connectionInformationList) {
        this.addConnectionInformation(elasticsearchConnection, connectionInformationList, "read");
    }

    protected void addConnectionInformation(ElasticsearchConnection elasticsearchConnection, List<ConnectionInformation> connectionInformationList, String ... labels) {
        ConnectionInformationBuilder connectionInformationBuilder;
        block7: {
            block6: {
                if (elasticsearchConnection == null) {
                    return;
                }
                connectionInformationBuilder = this.connectionInformationBuilderFactory.getConnectionInformationBuilder();
                try {
                    this._setClusterAndNodeInformation(connectionInformationBuilder, elasticsearchConnection.getClient());
                }
                catch (Exception exception) {
                    connectionInformationBuilder.error(exception.toString());
                    if (!_log.isWarnEnabled()) break block6;
                    _log.warn((Object)"Unable to get node information", (Throwable)exception);
                }
            }
            connectionInformationBuilder.connectionId(elasticsearchConnection.getConnectionId());
            try {
                this._setHealthInformation(connectionInformationBuilder, elasticsearchConnection.getClient());
            }
            catch (RuntimeException runtimeException) {
                connectionInformationBuilder.health("unknown");
                if (!_log.isWarnEnabled()) break block7;
                _log.warn((Object)"Unable to get health information", (Throwable)runtimeException);
            }
        }
        if (ArrayUtil.isNotEmpty((Object[])labels)) {
            connectionInformationBuilder.labels(SetUtil.fromArray((Object[])labels));
        }
        connectionInformationList.add(connectionInformationBuilder.build());
    }

    protected void addMainConnection(ElasticsearchConnection elasticsearchConnection, List<ConnectionInformation> connectionInformationList) {
        String[] labels = new String[]{"read", "write"};
        if (!this.isOperationModeEmbedded() && this.elasticsearchConnectionManager.isCrossClusterReplicationEnabled() && !elasticsearchConnection.equals(this.elasticsearchConnectionManager.getElasticsearchConnection(true))) {
            labels = new String[]{"write"};
        }
        this.addConnectionInformation(elasticsearchConnection, connectionInformationList, labels);
    }

    protected String getClusterNodesString(Client client) {
        try {
            if (client == null) {
                return "";
            }
            ConnectionInformationBuilder connectionInformationBuilder = this.connectionInformationBuilderFactory.getConnectionInformationBuilder();
            this._setClusterAndNodeInformation(connectionInformationBuilder, client);
            ConnectionInformation connectionInformation = connectionInformationBuilder.build();
            String clusterName = connectionInformation.getClusterName();
            List nodeInformations = connectionInformation.getNodeInformationList();
            Stream stream = nodeInformations.stream();
            String nodesString = stream.map(nodeInfo -> {
                StringBundler sb = new StringBundler(5);
                sb.append(nodeInfo.getName());
                sb.append(" ");
                sb.append("(");
                sb.append(nodeInfo.getVersion());
                sb.append(")");
                return sb.toString();
            }).collect(Collectors.joining(", "));
            StringBundler sb = new StringBundler(6);
            sb.append(clusterName);
            sb.append(":");
            sb.append(" ");
            sb.append("[");
            sb.append(nodesString);
            sb.append("]");
            return sb.toString();
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to get node information", (Throwable)exception);
            }
            StringBundler sb = new StringBundler(6);
            sb.append("(");
            sb.append("Error");
            sb.append(":");
            sb.append(" ");
            sb.append(exception.toString());
            sb.append(")");
            return sb.toString();
        }
    }

    protected boolean isCrossClusterReplicationInstalled() {
        return this.crossClusterReplicationConfigurationWrapper != null;
    }

    protected boolean isOperationModeEmbedded() {
        OperationMode operationMode = this.elasticsearchConfiguration.operationMode();
        return Objects.equals(operationMode, OperationMode.EMBEDDED);
    }

    private void _setClusterAndNodeInformation(ConnectionInformationBuilder connectionInformationBuilder, Client client) {
        AdminClient adminClient = client.admin();
        ClusterAdminClient clusterAdminClient = adminClient.cluster();
        NodesInfoRequestBuilder nodesInfoRequestBuilder = clusterAdminClient.prepareNodesInfo(new String[0]);
        TimeValue timeout = TimeValue.timeValueMillis((long)10000L);
        NodesInfoResponse nodesInfoResponse = (NodesInfoResponse)nodesInfoRequestBuilder.get(timeout);
        ClusterName clusterName = nodesInfoResponse.getClusterName();
        connectionInformationBuilder.clusterName(clusterName.value());
        ArrayList<NodeInformation> nodeInformationList = new ArrayList<NodeInformation>();
        for (NodeInfo nodeInfo : nodesInfoResponse.getNodes()) {
            NodeInformationBuilder nodeInformationBuilder = this.nodeInformationBuilderFactory.getNodeInformationBuilder();
            DiscoveryNode node = nodeInfo.getNode();
            nodeInformationBuilder.name(node.getName());
            Version version = node.getVersion();
            nodeInformationBuilder.version(version.toString());
            nodeInformationList.add(nodeInformationBuilder.build());
        }
        connectionInformationBuilder.nodeInformationList(nodeInformationList);
    }

    private void _setHealthInformation(ConnectionInformationBuilder connectionInformationBuilder, Client client) {
        AdminClient adminClient = client.admin();
        ClusterAdminClient clusterAdminClient = adminClient.cluster();
        ClusterHealthRequestBuilder clusterHealthRequestBuilder = clusterAdminClient.prepareHealth(new String[0]);
        ClusterHealthResponse clusterHealthResponse = (ClusterHealthResponse)clusterHealthRequestBuilder.get();
        ClusterHealthStatus clusterHealthStatus = this.clusterHealthStatusTranslator.translate(clusterHealthResponse.getStatus());
        connectionInformationBuilder.health(clusterHealthStatus.toString());
    }
}

