/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.index;

import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.index.IndexInformation;
import com.liferay.portal.search.index.IndexNameBuilder;
import org.elasticsearch.action.admin.indices.get.GetIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequestBuilder;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={IndexInformation.class})
public class ElasticsearchIndexInformation
implements IndexInformation {
    @Reference
    protected ElasticsearchClientResolver elasticsearchClientResolver;
    @Reference
    protected IndexNameBuilder indexNameBuilder;

    public String getCompanyIndexName(long companyId) {
        return this.indexNameBuilder.getIndexName(companyId);
    }

    public String getFieldMappings(String indexName) {
        IndicesAdminClient indicesAdminClient = this.getIndicesAdminClient();
        GetMappingsRequestBuilder getMappingsRequestBuilder = indicesAdminClient.prepareGetMappings(new String[]{indexName});
        return Strings.toString((ToXContent)((ToXContent)getMappingsRequestBuilder.get()), (boolean)true, (boolean)true);
    }

    public String[] getIndexNames() {
        IndicesAdminClient indicesAdminClient = this.getIndicesAdminClient();
        GetIndexRequestBuilder getIndexRequestBuilder = indicesAdminClient.prepareGetIndex();
        GetIndexResponse getIndexResponse = (GetIndexResponse)getIndexRequestBuilder.get();
        return getIndexResponse.getIndices();
    }

    protected IndicesAdminClient getIndicesAdminClient() {
        Client client = this.elasticsearchClientResolver.getClient(true);
        AdminClient adminClient = client.admin();
        return adminClient.indices();
    }
}

