/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.index;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.configuration.ElasticsearchConfiguration;
import com.liferay.portal.search.elasticsearch7.internal.index.IndexFactory;
import com.liferay.portal.search.elasticsearch7.internal.index.LiferayDocumentTypeFactory;
import com.liferay.portal.search.elasticsearch7.internal.index.contributor.IndexContributorReceiver;
import com.liferay.portal.search.elasticsearch7.internal.settings.SettingsBuilder;
import com.liferay.portal.search.elasticsearch7.internal.util.LogUtil;
import com.liferay.portal.search.elasticsearch7.internal.util.ResourceUtil;
import com.liferay.portal.search.elasticsearch7.settings.IndexSettingsHelper;
import com.liferay.portal.search.elasticsearch7.settings.TypeMappingsHelper;
import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.search.spi.model.index.contributor.IndexContributor;
import com.liferay.portal.search.spi.settings.IndexSettingsContributor;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequestBuilder;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.portal.search.elasticsearch7.configuration.ElasticsearchConfiguration"}, immediate=true, service={IndexContributorReceiver.class, IndexFactory.class})
public class CompanyIndexFactory
implements IndexContributorReceiver,
IndexFactory {
    @Reference
    protected IndexNameBuilder indexNameBuilder;
    @Reference
    protected JSONFactory jsonFactory;
    private static final Log _log = LogFactoryUtil.getLog(CompanyIndexFactory.class);
    private volatile String _additionalIndexConfigurations;
    private String _additionalTypeMappings;
    private final Set<Long> _companyIds = new HashSet<Long>();
    private final Set<com.liferay.portal.search.elasticsearch7.settings.IndexSettingsContributor> _elasticsearchIndexSettingsContributors = new ConcurrentSkipListSet<com.liferay.portal.search.elasticsearch7.settings.IndexSettingsContributor>();
    private final List<IndexContributor> _indexContributors = new CopyOnWriteArrayList<IndexContributor>();
    private String _indexNumberOfReplicas;
    private String _indexNumberOfShards;
    private final Set<IndexSettingsContributor> _indexSettingsContributors = ConcurrentHashMap.newKeySet();
    private IndicesAdminClient _indicesAdminClient;
    private String _overrideTypeMappings;

    @Override
    public void addIndexContributor(IndexContributor indexContributor) {
        this._indexContributors.add(indexContributor);
    }

    @Override
    public void createIndices(AdminClient adminClient, long companyId) {
        IndicesAdminClient indicesAdminClient;
        this._indicesAdminClient = indicesAdminClient = adminClient.indices();
        String indexName = this.getIndexName(companyId);
        if (this.hasIndex(indicesAdminClient, indexName)) {
            return;
        }
        this.createIndex(indexName, indicesAdminClient);
        this._companyIds.add(companyId);
    }

    @Override
    public void deleteIndices(AdminClient adminClient, long companyId) {
        String indexName;
        IndicesAdminClient indicesAdminClient = adminClient.indices();
        if (!this.hasIndex(indicesAdminClient, indexName = this.getIndexName(companyId))) {
            return;
        }
        this.executeIndexContributorsBeforeRemove(indexName);
        DeleteIndexRequestBuilder deleteIndexRequestBuilder = indicesAdminClient.prepareDelete(new String[]{indexName});
        ActionResponse actionResponse = deleteIndexRequestBuilder.get();
        LogUtil.logActionResponse(_log, actionResponse);
        this._companyIds.remove(companyId);
    }

    @Override
    public void removeIndexContributor(IndexContributor indexContributor) {
        this._indexContributors.remove(indexContributor);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        ElasticsearchConfiguration elasticsearchConfiguration = (ElasticsearchConfiguration)ConfigurableUtil.createConfigurable(ElasticsearchConfiguration.class, properties);
        this.setAdditionalIndexConfigurations(elasticsearchConfiguration.additionalIndexConfigurations());
        this.setAdditionalTypeMappings(elasticsearchConfiguration.additionalTypeMappings());
        this.setIndexNumberOfReplicas(elasticsearchConfiguration.indexNumberOfReplicas());
        this.setIndexNumberOfShards(elasticsearchConfiguration.indexNumberOfShards());
        this.setOverrideTypeMappings(elasticsearchConfiguration.overrideTypeMappings());
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addElasticsearchIndexSettingsContributor(com.liferay.portal.search.elasticsearch7.settings.IndexSettingsContributor indexSettingsContributor) {
        this._elasticsearchIndexSettingsContributors.add(indexSettingsContributor);
        this.processContributions((indexName, liferayDocumentTypeFactory) -> indexSettingsContributor.contribute(indexName, (TypeMappingsHelper)liferayDocumentTypeFactory));
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addIndexSettingsContributor(IndexSettingsContributor indexSettingsContributor) {
        this._indexSettingsContributors.add(indexSettingsContributor);
        this.processContributions((indexName, liferayDocumentTypeFactory) -> indexSettingsContributor.contribute(indexName, (com.liferay.portal.search.spi.settings.TypeMappingsHelper)liferayDocumentTypeFactory));
    }

    protected void addLiferayDocumentTypeMappings(CreateIndexRequestBuilder createIndexRequestBuilder, LiferayDocumentTypeFactory liferayDocumentTypeFactory) {
        if (Validator.isNotNull((String)this._overrideTypeMappings)) {
            liferayDocumentTypeFactory.createLiferayDocumentTypeMappings(createIndexRequestBuilder, this._overrideTypeMappings);
        } else {
            liferayDocumentTypeFactory.createRequiredDefaultTypeMappings(createIndexRequestBuilder);
        }
    }

    protected void createIndex(String indexName, IndicesAdminClient indicesAdminClient) {
        CreateIndexRequestBuilder createIndexRequestBuilder = indicesAdminClient.prepareCreate(indexName);
        LiferayDocumentTypeFactory liferayDocumentTypeFactory = new LiferayDocumentTypeFactory(indicesAdminClient, this.jsonFactory);
        this.setSettings(createIndexRequestBuilder, liferayDocumentTypeFactory);
        this.addLiferayDocumentTypeMappings(createIndexRequestBuilder, liferayDocumentTypeFactory);
        CreateIndexResponse createIndexResponse = (CreateIndexResponse)createIndexRequestBuilder.get();
        LogUtil.logActionResponse(_log, (ActionResponse)createIndexResponse);
        this.updateLiferayDocumentType(indexName, liferayDocumentTypeFactory);
        this.executeIndexContributorsAfterCreate(indexName);
    }

    protected void executeIndexContributorAfterCreate(IndexContributor indexContributor, String indexName) {
        try {
            indexContributor.onAfterCreate(indexName);
        }
        catch (Throwable t) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to apply contributor ", indexContributor, "to index ", indexName}), t);
        }
    }

    protected void executeIndexContributorBeforeRemove(IndexContributor indexContributor, String indexName) {
        try {
            indexContributor.onBeforeRemove(indexName);
        }
        catch (Throwable t) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to apply contributor ", indexContributor, " when removing index ", indexName}), t);
        }
    }

    protected void executeIndexContributorsAfterCreate(String indexName) {
        for (IndexContributor indexContributor : this._indexContributors) {
            this.executeIndexContributorAfterCreate(indexContributor, indexName);
        }
    }

    protected void executeIndexContributorsBeforeRemove(String indexName) {
        for (IndexContributor indexContributor : this._indexContributors) {
            this.executeIndexContributorBeforeRemove(indexContributor, indexName);
        }
    }

    protected String getIndexName(long companyId) {
        return this.indexNameBuilder.getIndexName(companyId);
    }

    protected boolean hasIndex(IndicesAdminClient indicesAdminClient, String indexName) {
        IndicesExistsRequestBuilder indicesExistsRequestBuilder = indicesAdminClient.prepareExists(new String[]{indexName});
        IndicesExistsResponse indicesExistsResponse = (IndicesExistsResponse)indicesExistsRequestBuilder.get();
        return indicesExistsResponse.isExists();
    }

    protected void loadAdditionalIndexConfigurations(SettingsBuilder settingsBuilder) {
        settingsBuilder.loadFromSource(this._additionalIndexConfigurations);
    }

    protected void loadAdditionalTypeMappings(String indexName, LiferayDocumentTypeFactory liferayDocumentTypeFactory) {
        if (Validator.isNull((String)this._additionalTypeMappings)) {
            return;
        }
        liferayDocumentTypeFactory.addTypeMappings(indexName, this._additionalTypeMappings);
    }

    protected void loadDefaultIndexSettings(SettingsBuilder settingsBuilder) {
        Settings.Builder builder = settingsBuilder.getBuilder();
        String defaultIndexSettings = ResourceUtil.getResourceAsString(this.getClass(), "/META-INF/index-settings-defaults.json");
        builder.loadFromSource(defaultIndexSettings, XContentType.JSON);
    }

    protected void loadIndexConfigurations(SettingsBuilder settingsBuilder) {
        settingsBuilder.put("index.number_of_replicas", this._indexNumberOfReplicas);
        settingsBuilder.put("index.number_of_shards", this._indexNumberOfShards);
    }

    protected void loadIndexSettingsContributors(Settings.Builder builder) {
        IndexSettingsHelper elasticsearchIndexSettingsHelper = (setting, value) -> builder.put(setting, value);
        for (com.liferay.portal.search.elasticsearch7.settings.IndexSettingsContributor indexSettingsContributor : this._elasticsearchIndexSettingsContributors) {
            indexSettingsContributor.populate(elasticsearchIndexSettingsHelper);
        }
        com.liferay.portal.search.spi.settings.IndexSettingsHelper indexSettingsHelper = (setting, value) -> builder.put(setting, value);
        for (IndexSettingsContributor indexSettingsContributor1 : this._indexSettingsContributors) {
            indexSettingsContributor1.populate(indexSettingsHelper);
        }
    }

    protected void loadTestModeIndexSettings(SettingsBuilder settingsBuilder) {
        if (!PortalRunMode.isTestMode()) {
            return;
        }
        settingsBuilder.put("index.refresh_interval", "1ms");
        settingsBuilder.put("index.search.slowlog.threshold.fetch.warn", "-1");
        settingsBuilder.put("index.search.slowlog.threshold.query.warn", "-1");
        settingsBuilder.put("index.translog.sync_interval", "100ms");
    }

    protected void loadTypeMappingsContributors(String indexName, LiferayDocumentTypeFactory liferayDocumentTypeFactory) {
        for (com.liferay.portal.search.elasticsearch7.settings.IndexSettingsContributor elasticsearchIndexSettingsContributor : this._elasticsearchIndexSettingsContributors) {
            elasticsearchIndexSettingsContributor.contribute(indexName, (TypeMappingsHelper)liferayDocumentTypeFactory);
        }
        for (IndexSettingsContributor indexSettingsContributor : this._indexSettingsContributors) {
            indexSettingsContributor.contribute(indexName, (com.liferay.portal.search.spi.settings.TypeMappingsHelper)liferayDocumentTypeFactory);
        }
    }

    protected void processContributions(BiConsumer<String, LiferayDocumentTypeFactory> biConsumer) {
        if (Validator.isNotNull((String)this._overrideTypeMappings) || this._indicesAdminClient == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Skipping index settings contributor");
            }
            return;
        }
        LiferayDocumentTypeFactory liferayDocumentTypeFactory = new LiferayDocumentTypeFactory(this._indicesAdminClient, this.jsonFactory);
        for (Long companyId : this._companyIds) {
            biConsumer.accept(this.getIndexName(companyId), liferayDocumentTypeFactory);
        }
    }

    protected void removeElasticsearchIndexSettingsContributor(com.liferay.portal.search.elasticsearch7.settings.IndexSettingsContributor indexSettingsContributor) {
        this._elasticsearchIndexSettingsContributors.remove(indexSettingsContributor);
    }

    protected void removeIndexSettingsContributor(IndexSettingsContributor indexSettingsContributor) {
        this._indexSettingsContributors.remove(indexSettingsContributor);
    }

    protected void setAdditionalIndexConfigurations(String additionalIndexConfigurations) {
        this._additionalIndexConfigurations = additionalIndexConfigurations;
    }

    protected void setAdditionalTypeMappings(String additionalTypeMappings) {
        this._additionalTypeMappings = additionalTypeMappings;
    }

    protected void setIndexNumberOfReplicas(String indexNumberOfReplicas) {
        this._indexNumberOfReplicas = indexNumberOfReplicas;
    }

    protected void setIndexNumberOfShards(String indexNumberOfShards) {
        this._indexNumberOfShards = indexNumberOfShards;
    }

    protected void setOverrideTypeMappings(String overrideTypeMappings) {
        this._overrideTypeMappings = overrideTypeMappings;
    }

    protected void setSettings(CreateIndexRequestBuilder createIndexRequestBuilder, LiferayDocumentTypeFactory liferayDocumentTypeFactory) {
        Settings.Builder builder = Settings.builder();
        liferayDocumentTypeFactory.createRequiredDefaultAnalyzers(builder);
        SettingsBuilder settingsBuilder = new SettingsBuilder(builder);
        this.loadDefaultIndexSettings(settingsBuilder);
        this.loadTestModeIndexSettings(settingsBuilder);
        this.loadIndexConfigurations(settingsBuilder);
        this.loadAdditionalIndexConfigurations(settingsBuilder);
        this.loadIndexSettingsContributors(builder);
        if (Validator.isNotNull((String)builder.get("index.number_of_replicas"))) {
            builder.put("index.auto_expand_replicas", false);
        }
        createIndexRequestBuilder.setSettings(builder);
    }

    protected void updateLiferayDocumentType(String indexName, LiferayDocumentTypeFactory liferayDocumentTypeFactory) {
        if (Validator.isNotNull((String)this._overrideTypeMappings)) {
            return;
        }
        this.loadAdditionalTypeMappings(indexName, liferayDocumentTypeFactory);
        this.loadTypeMappingsContributors(indexName, liferayDocumentTypeFactory);
        liferayDocumentTypeFactory.createOptionalDefaultTypeMappings(indexName);
    }
}

