/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.connection;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.configuration.ElasticsearchConfiguration;
import com.liferay.portal.search.elasticsearch7.internal.cluster.ClusterSettingsContext;
import com.liferay.portal.search.elasticsearch7.internal.connection.BaseElasticsearchConnection;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnection;
import com.liferay.portal.search.elasticsearch7.internal.connection.EmbeddedElasticsearchNode;
import com.liferay.portal.search.elasticsearch7.internal.connection.EmbeddedElasticsearchPluginManager;
import com.liferay.portal.search.elasticsearch7.internal.connection.OperationMode;
import com.liferay.portal.search.elasticsearch7.internal.connection.PluginManagerFactoryImpl;
import com.liferay.portal.search.elasticsearch7.internal.connection.PluginZipFactoryImpl;
import com.liferay.portal.search.elasticsearch7.internal.index.IndexFactory;
import com.liferay.portal.search.elasticsearch7.settings.SettingsContributor;
import io.netty.buffer.ByteBufUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.time.StopWatch;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeValidationException;
import org.elasticsearch.threadpool.ThreadPool;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.portal.search.elasticsearch7.configuration.ElasticsearchConfiguration"}, immediate=true, property={"operation.mode=EMBEDDED"}, service={ElasticsearchConnection.class})
public class EmbeddedElasticsearchConnection
extends BaseElasticsearchConnection {
    public static final String CONNECTION_ID = "EMBEDDED";
    protected static final String JNA_TMP_DIR = "elasticSearch-tmpDir";
    @Reference
    protected ClusterSettingsContext clusterSettingsContext;
    @Reference
    protected Props props;
    private static final RejectedExecutionHandler _REJECTED_EXECUTION_HANDLER = new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Discarded ", runnable, " on ", threadPoolExecutor}));
            }
        }
    };
    private static final Log _log = LogFactoryUtil.getLog(EmbeddedElasticsearchConnection.class);
    private static String _jnaTmpDirName;
    @Reference
    private File _file;
    private Node _node;

    @Override
    public void close() {
        block10: {
            block9: {
                super.close();
                if (this._node == null) {
                    return;
                }
                try {
                    Class.forName(ByteBufUtil.class.getName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!_log.isWarnEnabled()) break block9;
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to preload ", ByteBufUtil.class, " to prevent Netty shutdown concurrent class loading ", "interruption issue"}), (Throwable)classNotFoundException);
                }
            }
            if (PortalRunMode.isTestMode()) {
                Injector injector = this._node.injector();
                ThreadPool threadPool = (ThreadPool)injector.getInstance(ThreadPool.class);
                ScheduledExecutorService scheduledExecutorService = threadPool.scheduler();
                if (scheduledExecutorService instanceof ThreadPoolExecutor) {
                    ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)((Object)scheduledExecutorService);
                    threadPoolExecutor.setRejectedExecutionHandler(_REJECTED_EXECUTION_HANDLER);
                }
                scheduledExecutorService.shutdown();
                try {
                    scheduledExecutorService.awaitTermination(1L, TimeUnit.HOURS);
                }
                catch (InterruptedException interruptedException) {
                    if (!_log.isWarnEnabled()) break block10;
                    _log.warn((Object)"Thread pool shutdown wait was interrupted", (Throwable)interruptedException);
                }
            }
        }
        try {
            this._node.close();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        this._node = null;
        this._file.deltree(_jnaTmpDirName);
    }

    @Override
    public String getConnectionId() {
        return CONNECTION_ID;
    }

    public Node getNode() {
        return this._node;
    }

    @Override
    public OperationMode getOperationMode() {
        return OperationMode.EMBEDDED;
    }

    @Override
    @Reference(unbind="-")
    public void setIndexFactory(IndexFactory indexFactory) {
        super.setIndexFactory(indexFactory);
    }

    @Activate
    @Modified
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this.elasticsearchConfiguration = (ElasticsearchConfiguration)ConfigurableUtil.createConfigurable(ElasticsearchConfiguration.class, properties);
        java.io.File tempDir = bundleContext.getDataFile(JNA_TMP_DIR);
        _jnaTmpDirName = tempDir.getAbsolutePath();
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(operation.mode=EMBEDDED)")
    protected void addSettingsContributor(SettingsContributor settingsContributor) {
        super.addSettingsContributor(settingsContributor);
    }

    protected void configureClustering() {
        this.settingsBuilder.put("cluster.name", this.elasticsearchConfiguration.clusterName());
        this.settingsBuilder.put("cluster.routing.allocation.disk.threshold_enabled", false);
        this.settingsBuilder.put("discovery.type", "single-node");
    }

    protected void configureHttp() {
        this.settingsBuilder.put("http.cors.enabled", this.elasticsearchConfiguration.httpCORSEnabled());
        if (!this.elasticsearchConfiguration.httpCORSEnabled()) {
            return;
        }
        this.settingsBuilder.put("http.cors.allow-origin", this.elasticsearchConfiguration.httpCORSAllowOrigin());
        this.settingsBuilder.loadFromSource(this.elasticsearchConfiguration.httpCORSConfigurations());
    }

    protected void configureNetworking() {
        String transportTcpPort;
        String networkPublishHost;
        InetAddress localBindInetAddress;
        String networkBindHost = this.elasticsearchConfiguration.networkBindHost();
        if (Validator.isNotNull((String)networkBindHost)) {
            this.settingsBuilder.put("network.bind.host", networkBindHost);
        }
        String networkHost = this.elasticsearchConfiguration.networkHost();
        if (Validator.isNull((String)networkBindHost) && Validator.isNull((String)networkHost) && Validator.isNull((String)this.elasticsearchConfiguration.networkPublishHost()) && (localBindInetAddress = this.clusterSettingsContext.getLocalBindInetAddress()) != null) {
            networkHost = localBindInetAddress.getHostAddress();
        }
        if (Validator.isNotNull((String)networkHost)) {
            this.settingsBuilder.put("network.host", networkHost);
        }
        if (Validator.isNotNull((String)(networkPublishHost = this.elasticsearchConfiguration.networkPublishHost()))) {
            this.settingsBuilder.put("network.publish.host", networkPublishHost);
        }
        if (Validator.isNotNull((String)(transportTcpPort = this.elasticsearchConfiguration.transportTcpPort()))) {
            this.settingsBuilder.put("transport.tcp.port", transportTcpPort);
        }
        this.settingsBuilder.put("transport.type", "netty4");
    }

    protected void configurePaths() {
        String liferayHome = this.props.get("liferay.home");
        this.settingsBuilder.put("path.data", liferayHome.concat("/data/elasticsearch7/indices"));
        this.settingsBuilder.put("path.home", liferayHome.concat("/data/elasticsearch7"));
        this.settingsBuilder.put("path.logs", liferayHome.concat("/logs"));
        this.settingsBuilder.put("path.repo", liferayHome.concat("/data/elasticsearch7/repo"));
    }

    protected void configureTestMode() {
        if (!PortalRunMode.isTestMode()) {
            return;
        }
        this.settingsBuilder.put("monitor.jvm.gc.enabled", "false");
    }

    @Override
    protected Client createClient() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (_log.isWarnEnabled()) {
            StringBundler sb = new StringBundler(8);
            sb.append("Liferay is configured to use embedded Elasticsearch ");
            sb.append("as its search engine. Do NOT use embedded ");
            sb.append("Elasticsearch in production. Embedded Elasticsearch ");
            sb.append("is useful for development and demonstration purposes. ");
            sb.append("Refer to the documentation for details on the ");
            sb.append("limitations of embedded Elasticsearch. Remote ");
            sb.append("Elasticsearch connections can be configured in the ");
            sb.append("Control Panel.");
            _log.warn((Object)sb.toString());
        }
        Settings settings = this.settingsBuilder.build();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Starting embedded Elasticsearch cluster " + this.elasticsearchConfiguration.clusterName()));
        }
        this._node = this.createNode(settings);
        try {
            this._node.start();
        }
        catch (NodeValidationException nodeValidationException) {
            throw new RuntimeException(nodeValidationException);
        }
        Client client = this._node.client();
        if (_log.isDebugEnabled()) {
            stopWatch.stop();
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Started ", this.elasticsearchConfiguration.clusterName(), " in ", stopWatch.getTime(), " ms"}));
        }
        return client;
    }

    protected EmbeddedElasticsearchPluginManager createEmbeddedElasticsearchPluginManager(String name, Settings settings) {
        return new EmbeddedElasticsearchPluginManager(name, this.props.get("liferay.home") + "/data/elasticsearch7/plugins", new PluginManagerFactoryImpl(settings), new PluginZipFactoryImpl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node createNode(Settings settings) {
        Thread thread = Thread.currentThread();
        ClassLoader contextClassLoader = thread.getContextClassLoader();
        Class<?> clazz = this.getClass();
        thread.setContextClassLoader(clazz.getClassLoader());
        String jnaTmpDir = System.getProperty("jna.tmpdir");
        System.setProperty("jna.tmpdir", _jnaTmpDirName);
        try {
            this.installPlugins(settings);
            Node node = EmbeddedElasticsearchNode.newInstance(settings);
            return node;
        }
        finally {
            thread.setContextClassLoader(contextClassLoader);
            if (jnaTmpDir == null) {
                System.clearProperty("jna.tmpdir");
            } else {
                System.setProperty("jna.tmpdir", jnaTmpDir);
            }
        }
    }

    @Deactivate
    protected void deactivate(Map<String, Object> properties) {
        this.close();
    }

    protected void installPlugin(String name, Settings settings) {
        EmbeddedElasticsearchPluginManager embeddedElasticsearchPluginManager = this.createEmbeddedElasticsearchPluginManager(name, settings);
        try {
            embeddedElasticsearchPluginManager.install();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to install " + name + " plugin", exception);
        }
    }

    protected void installPlugins(Settings settings) {
        String[] plugins;
        for (String plugin : plugins = new String[]{"analysis-icu", "analysis-kuromoji", "analysis-smartcn", "analysis-stempel"}) {
            this.removeObsoletePlugin(plugin, settings);
        }
        for (String plugin : plugins) {
            this.installPlugin(plugin, settings);
        }
        LogManager.shutdown();
    }

    @Override
    protected void loadRequiredDefaultConfigurations() {
        this.settingsBuilder.put("action.auto_create_index", false);
        this.settingsBuilder.put("bootstrap.memory_lock", this.elasticsearchConfiguration.bootstrapMlockAll());
        this.configureClustering();
        this.configureHttp();
        this.configureNetworking();
        this.settingsBuilder.put("node.data", true);
        this.settingsBuilder.put("node.ingest", true);
        this.settingsBuilder.put("node.master", true);
        this.configurePaths();
        this.configureTestMode();
    }

    protected void removeObsoletePlugin(String name, Settings settings) {
        EmbeddedElasticsearchPluginManager embeddedElasticsearchPluginManager = this.createEmbeddedElasticsearchPluginManager(name, settings);
        try {
            embeddedElasticsearchPluginManager.removeObsoletePlugin();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to remove " + name + " plugin", exception);
        }
    }

    @Override
    protected void removeSettingsContributor(SettingsContributor settingsContributor) {
        super.removeSettingsContributor(settingsContributor);
    }
}

