/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.aggregation.pipeline;

import com.liferay.portal.search.aggregation.AggregationResult;
import com.liferay.portal.search.aggregation.AggregationResults;
import com.liferay.portal.search.aggregation.pipeline.AvgBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.AvgBucketPipelineAggregationResult;
import com.liferay.portal.search.aggregation.pipeline.BucketScriptPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.BucketScriptPipelineAggregationResult;
import com.liferay.portal.search.aggregation.pipeline.BucketSelectorPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.BucketSortPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.CumulativeSumPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.CumulativeSumPipelineAggregationResult;
import com.liferay.portal.search.aggregation.pipeline.DerivativePipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.DerivativePipelineAggregationResult;
import com.liferay.portal.search.aggregation.pipeline.ExtendedStatsBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.ExtendedStatsBucketPipelineAggregationResult;
import com.liferay.portal.search.aggregation.pipeline.MaxBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.MaxBucketPipelineAggregationResult;
import com.liferay.portal.search.aggregation.pipeline.MinBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.MinBucketPipelineAggregationResult;
import com.liferay.portal.search.aggregation.pipeline.MovingFunctionPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.MovingFunctionPipelineAggregationResult;
import com.liferay.portal.search.aggregation.pipeline.PercentilesBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.PercentilesBucketPipelineAggregationResult;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregationResultTranslator;
import com.liferay.portal.search.aggregation.pipeline.SerialDiffPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.SerialDiffPipelineAggregationResult;
import com.liferay.portal.search.aggregation.pipeline.StatsBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.StatsBucketPipelineAggregationResult;
import com.liferay.portal.search.aggregation.pipeline.SumBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.SumBucketPipelineAggregationResult;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.pipeline.BucketMetricValue;
import org.elasticsearch.search.aggregations.pipeline.Derivative;
import org.elasticsearch.search.aggregations.pipeline.ExtendedStatsBucket;
import org.elasticsearch.search.aggregations.pipeline.PercentilesBucket;
import org.elasticsearch.search.aggregations.pipeline.SimpleValue;
import org.elasticsearch.search.aggregations.pipeline.StatsBucket;

public class ElasticsearchPipelineAggregationResultTranslator
implements PipelineAggregationResultTranslator {
    private final AggregationResults _aggregationResults;
    private final Aggregation _elasticsearchAggregation;

    public ElasticsearchPipelineAggregationResultTranslator(Aggregation elasticsearchAggregation, AggregationResults aggregationResults) {
        this._elasticsearchAggregation = elasticsearchAggregation;
        this._aggregationResults = aggregationResults;
    }

    public AvgBucketPipelineAggregationResult visit(AvgBucketPipelineAggregation avgAggregation) {
        SimpleValue simpleValue = (SimpleValue)this._elasticsearchAggregation;
        return this._aggregationResults.avgBucket(simpleValue.getName(), simpleValue.value());
    }

    public BucketScriptPipelineAggregationResult visit(BucketScriptPipelineAggregation bucketScriptPipelineAggregation) {
        SimpleValue simpleValue = (SimpleValue)this._elasticsearchAggregation;
        return this._aggregationResults.bucketScript(simpleValue.getName(), simpleValue.value());
    }

    public AggregationResult visit(BucketSelectorPipelineAggregation bucketSelectorPipelineAggregation) {
        throw new UnsupportedOperationException("BucketSelector does not return a separate AggregationResult");
    }

    public AggregationResult visit(BucketSortPipelineAggregation bucketSortPipelineAggregation) {
        throw new UnsupportedOperationException("BucketSort does not return a separate AggregationResult");
    }

    public CumulativeSumPipelineAggregationResult visit(CumulativeSumPipelineAggregation cumulativeSumPipelineAggregation) {
        SimpleValue simpleValue = (SimpleValue)this._elasticsearchAggregation;
        return this._aggregationResults.cumulativeSum(simpleValue.getName(), simpleValue.value());
    }

    public DerivativePipelineAggregationResult visit(DerivativePipelineAggregation derivativePipelineAggregation) {
        Derivative derivative = (Derivative)this._elasticsearchAggregation;
        return this._aggregationResults.derivative(derivative.getName(), derivative.normalizedValue());
    }

    public ExtendedStatsBucketPipelineAggregationResult visit(ExtendedStatsBucketPipelineAggregation extendedStatsBucketPipelineAggregation) {
        ExtendedStatsBucket extendedStatsBucket = (ExtendedStatsBucket)this._elasticsearchAggregation;
        return this._aggregationResults.extendedStatsBucket(extendedStatsBucket.getName(), extendedStatsBucket.getAvg(), extendedStatsBucket.getCount(), extendedStatsBucket.getMin(), extendedStatsBucket.getMax(), extendedStatsBucket.getSum(), extendedStatsBucket.getSumOfSquares(), extendedStatsBucket.getVariance(), extendedStatsBucket.getStdDeviation());
    }

    public MaxBucketPipelineAggregationResult visit(MaxBucketPipelineAggregation maxBucketPipelineAggregation) {
        BucketMetricValue bucketMetricValue = (BucketMetricValue)this._elasticsearchAggregation;
        MaxBucketPipelineAggregationResult maxBucketPipelineAggregationResult = this._aggregationResults.maxBucket(bucketMetricValue.getName(), bucketMetricValue.value());
        maxBucketPipelineAggregationResult.setKeys(bucketMetricValue.keys());
        return maxBucketPipelineAggregationResult;
    }

    public MinBucketPipelineAggregationResult visit(MinBucketPipelineAggregation minBucketPipelineAggregation) {
        BucketMetricValue bucketMetricValue = (BucketMetricValue)this._elasticsearchAggregation;
        MinBucketPipelineAggregationResult minBucketPipelineAggregationResult = this._aggregationResults.minBucket(bucketMetricValue.getName(), bucketMetricValue.value());
        minBucketPipelineAggregationResult.setKeys(bucketMetricValue.keys());
        return minBucketPipelineAggregationResult;
    }

    public MovingFunctionPipelineAggregationResult visit(MovingFunctionPipelineAggregation movingFunctionPipelineAggregation) {
        SimpleValue simpleValue = (SimpleValue)this._elasticsearchAggregation;
        return this._aggregationResults.movingFunction(simpleValue.getName(), simpleValue.value());
    }

    public PercentilesBucketPipelineAggregationResult visit(PercentilesBucketPipelineAggregation percentilesBucketPipelineAggregation) {
        PercentilesBucket percentilesBucket = (PercentilesBucket)this._elasticsearchAggregation;
        PercentilesBucketPipelineAggregationResult percentilesBucketPipelineAggregationResult = this._aggregationResults.percentilesBucket(percentilesBucket.getName());
        percentilesBucket.forEach(percentile -> percentilesBucketPipelineAggregationResult.addPercentile(percentile.getPercent(), percentile.getValue()));
        return percentilesBucketPipelineAggregationResult;
    }

    public SerialDiffPipelineAggregationResult visit(SerialDiffPipelineAggregation serialDiffPipelineAggregation) {
        SimpleValue simpleValue = (SimpleValue)this._elasticsearchAggregation;
        return this._aggregationResults.serialDiff(simpleValue.getName(), simpleValue.value());
    }

    public StatsBucketPipelineAggregationResult visit(StatsBucketPipelineAggregation statsBucketPipelineAggregation) {
        StatsBucket statsBucket = (StatsBucket)this._elasticsearchAggregation;
        return this._aggregationResults.statsBucket(statsBucket.getName(), statsBucket.getAvg(), statsBucket.getCount(), statsBucket.getMin(), statsBucket.getMax(), statsBucket.getSum());
    }

    public SumBucketPipelineAggregationResult visit(SumBucketPipelineAggregation sumBucketPipelineAggregation) {
        SimpleValue simpleValue = (SimpleValue)this._elasticsearchAggregation;
        return this._aggregationResults.sumBucket(simpleValue.getName(), simpleValue.value());
    }
}

