/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.aggregation.metrics;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.search.aggregation.AggregationTranslator;
import com.liferay.portal.search.aggregation.metrics.TopHitsAggregation;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregationTranslator;
import com.liferay.portal.search.elasticsearch7.internal.aggregation.metrics.TopHitsAggregationTranslator;
import com.liferay.portal.search.elasticsearch7.internal.highlight.HighlightTranslator;
import com.liferay.portal.search.elasticsearch7.internal.script.ScriptTranslator;
import com.liferay.portal.search.query.QueryTranslator;
import com.liferay.portal.search.sort.SortFieldTranslator;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.TopHitsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={TopHitsAggregationTranslator.class})
public class TopHitsAggregationTranslatorImpl
implements TopHitsAggregationTranslator {
    private final HighlightTranslator _highlightTranslator = new HighlightTranslator();
    private QueryTranslator<QueryBuilder> _queryTranslator;
    private final ScriptTranslator _scriptTranslator = new ScriptTranslator();
    private SortFieldTranslator<SortBuilder> _sortFieldTranslator;

    @Override
    public TopHitsAggregationBuilder translate(TopHitsAggregation topHitsAggregation, AggregationTranslator<AggregationBuilder> aggregationTranslator, PipelineAggregationTranslator<PipelineAggregationBuilder> pipelineAggregationTranslator) {
        TopHitsAggregationBuilder topHitsAggregationBuilder = AggregationBuilders.topHits((String)topHitsAggregation.getName());
        if (topHitsAggregation.getExplain() != null) {
            topHitsAggregationBuilder.explain(topHitsAggregation.getExplain().booleanValue());
        }
        if (ListUtil.isNotEmpty((List)topHitsAggregation.getSelectedFields())) {
            List selectedFields = topHitsAggregation.getSelectedFields();
            selectedFields.forEach(arg_0 -> ((TopHitsAggregationBuilder)topHitsAggregationBuilder).docValueField(arg_0));
        }
        if (topHitsAggregation.getFetchSource() != null) {
            topHitsAggregationBuilder.fetchSource(topHitsAggregation.getFetchSource().booleanValue());
            if (topHitsAggregation.getFetchSource().booleanValue() && (topHitsAggregation.getFetchSourceInclude() != null || topHitsAggregation.getFetchSourceExclude() != null)) {
                topHitsAggregationBuilder.fetchSource(topHitsAggregation.getFetchSourceInclude(), topHitsAggregation.getFetchSourceExclude());
            }
        }
        if (topHitsAggregation.getFrom() != null) {
            topHitsAggregationBuilder.from(topHitsAggregation.getFrom().intValue());
        }
        if (topHitsAggregation.getHighlight() != null) {
            HighlightBuilder highlightBuilder = this._highlightTranslator.translate(topHitsAggregation.getHighlight(), this._queryTranslator);
            topHitsAggregationBuilder.highlighter(highlightBuilder);
        }
        if (topHitsAggregation.getScriptFields() != null) {
            List scriptFields = topHitsAggregation.getScriptFields();
            ArrayList searchSourceBuilderScriptFields = new ArrayList(scriptFields.size());
            scriptFields.forEach(scriptField -> {
                Script script = this._scriptTranslator.translate(scriptField.getScript());
                SearchSourceBuilder.ScriptField searchSourceBuilderScriptField = new SearchSourceBuilder.ScriptField(scriptField.getField(), script, scriptField.isIgnoreFailure());
                searchSourceBuilderScriptFields.add(searchSourceBuilderScriptField);
            });
            topHitsAggregationBuilder.scriptFields(searchSourceBuilderScriptFields);
        }
        if (topHitsAggregation.getSize() != null) {
            topHitsAggregationBuilder.size(topHitsAggregation.getSize().intValue());
        }
        if (ListUtil.isNotEmpty((List)topHitsAggregation.getSortFields())) {
            List sorts = topHitsAggregation.getSortFields();
            ArrayList sortBuilders = new ArrayList(sorts.size());
            sorts.forEach(sort -> sortBuilders.add(this._sortFieldTranslator.translate(sort)));
            topHitsAggregationBuilder.sorts(sortBuilders);
        }
        topHitsAggregationBuilder.storedFields();
        if (topHitsAggregation.getTrackScores() != null) {
            topHitsAggregationBuilder.trackScores(topHitsAggregation.getTrackScores().booleanValue());
        }
        if (topHitsAggregation.getVersion() != null) {
            topHitsAggregationBuilder.version(topHitsAggregation.getVersion().booleanValue());
        }
        return topHitsAggregationBuilder;
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    protected void setQueryTranslator(QueryTranslator<QueryBuilder> queryTranslator) {
        this._queryTranslator = queryTranslator;
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    protected void setSortFieldTranslator(SortFieldTranslator<SortBuilder> sortFieldTranslator) {
        this._sortFieldTranslator = sortFieldTranslator;
    }
}

