/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal;

import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchEngineConfigurator;
import com.liferay.portal.kernel.search.SearchEngineHelper;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.BaseSearchEngineConfigurator;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnection;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnectionManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"search.engine.impl=Elasticsearch"}, service={SearchEngineConfigurator.class})
public class ElasticsearchEngineConfigurator
extends BaseSearchEngineConfigurator {
    private BundleContext _bundleContext;
    private DestinationFactory _destinationFactory;
    private ElasticsearchConnectionManager _elasticsearchConnectionManager;
    private IndexSearcher _indexSearcher;
    private IndexWriter _indexWriter;
    private MessageBus _messageBus;
    private SearchEngineHelper _searchEngineHelper;
    private final Map<String, SearchEngine> _searchEngines = new ConcurrentHashMap<String, SearchEngine>();

    @Override
    public void destroy() {
        ElasticsearchConnection elasticsearchConnection = this._elasticsearchConnectionManager.getElasticsearchConnection();
        elasticsearchConnection.close();
        super.destroy();
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        this._bundleContext = componentContext.getBundleContext();
        this.setSearchEngines(this._searchEngines);
        this.initialize();
    }

    @Override
    protected BundleContext getBundleContext() {
        return this._bundleContext;
    }

    @Override
    protected String getDefaultSearchEngineId() {
        return "SYSTEM_ENGINE";
    }

    @Override
    protected DestinationFactory getDestinationFactory() {
        return this._destinationFactory;
    }

    @Override
    protected IndexSearcher getIndexSearcher() {
        return this._indexSearcher;
    }

    @Override
    protected IndexWriter getIndexWriter() {
        return this._indexWriter;
    }

    @Override
    protected MessageBus getMessageBus() {
        return this._messageBus;
    }

    @Override
    protected ClassLoader getOperatingClassLoader() {
        Class<?> clazz = this.getClass();
        return clazz.getClassLoader();
    }

    @Override
    protected SearchEngineHelper getSearchEngineHelper() {
        return this._searchEngineHelper;
    }

    @Override
    protected void initialize() {
        FutureTask<Void> futureTask = new FutureTask<Void>(() -> {
            this._elasticsearchConnectionManager.connect();
            return null;
        });
        Thread thread = new Thread(futureTask, "Elasticsearch Initialization Thread");
        thread.setDaemon(true);
        thread.start();
        try {
            futureTask.get();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to initialize Elasticsearch engine", exception);
        }
        super.initialize();
    }

    @Reference(unbind="-")
    protected void setDestinationFactory(DestinationFactory destinationFactory) {
        this._destinationFactory = destinationFactory;
    }

    @Reference(unbind="-")
    protected void setElasticsearchConnectionManager(ElasticsearchConnectionManager elasticsearchConnectionManager) {
        this._elasticsearchConnectionManager = elasticsearchConnectionManager;
    }

    @Reference(target="(!(search.engine.impl=*))", unbind="-")
    protected void setIndexSearcher(IndexSearcher indexSearcher) {
        this._indexSearcher = indexSearcher;
    }

    @Reference(target="(!(search.engine.impl=*))", unbind="-")
    protected void setIndexWriter(IndexWriter indexWriter) {
        this._indexWriter = indexWriter;
    }

    @Reference(unbind="-")
    protected void setMessageBus(MessageBus messageBus) {
        this._messageBus = messageBus;
    }

    @Reference(target="(&(search.engine.id=SYSTEM_ENGINE)(search.engine.impl=Elasticsearch))")
    protected void setSearchEngine(SearchEngine searchEngine, Map<String, Object> properties) {
        String searchEngineId = MapUtil.getString(properties, (String)"search.engine.id");
        this._searchEngines.put(searchEngineId, searchEngine);
    }

    @Reference(unbind="-")
    protected void setSearchEngineHelper(SearchEngineHelper searchEngineHelper) {
        this._searchEngineHelper = searchEngineHelper;
    }

    protected void unsetSearchEngine(SearchEngine searchEngine, Map<String, Object> properties) {
        String searchEngineId = MapUtil.getString(properties, (String)"search.engine.id");
        if (Validator.isNull((String)searchEngineId)) {
            return;
        }
        this._searchEngines.remove(searchEngineId);
    }
}

