/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.snapshot;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.snapshot.GetSnapshotRepositoriesRequestExecutor;
import com.liferay.portal.search.engine.adapter.snapshot.GetSnapshotRepositoriesRequest;
import com.liferay.portal.search.engine.adapter.snapshot.GetSnapshotRepositoriesResponse;
import com.liferay.portal.search.engine.adapter.snapshot.SnapshotRepositoryDetails;
import java.util.List;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesAction;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesRequestBuilder;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={GetSnapshotRepositoriesRequestExecutor.class})
public class GetSnapshotRepositoriesRequestExecutorImpl
implements GetSnapshotRepositoriesRequestExecutor {
    private static final Log _log = LogFactoryUtil.getLog(GetSnapshotRepositoriesRequestExecutorImpl.class);
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public GetSnapshotRepositoriesResponse execute(GetSnapshotRepositoriesRequest getSnapshotRepositoriesRequest) {
        GetSnapshotRepositoriesResponse getSnapshotRepositoriesResponse;
        block2: {
            GetRepositoriesRequestBuilder getRepositoriesRequestBuilder = this.createGetRepositoriesRequestBuilder(getSnapshotRepositoriesRequest);
            getSnapshotRepositoriesResponse = new GetSnapshotRepositoriesResponse();
            try {
                GetRepositoriesResponse elasticsearchGetRepositoriesResponse = (GetRepositoriesResponse)getRepositoriesRequestBuilder.get();
                List repositoriesMetadatas = elasticsearchGetRepositoriesResponse.repositories();
                repositoriesMetadatas.forEach(repositoryMetadata -> {
                    Settings repositoryMetadataSettings = repositoryMetadata.settings();
                    SnapshotRepositoryDetails snapshotRepositoryDetails = new SnapshotRepositoryDetails(repositoryMetadata.name(), repositoryMetadata.type(), repositoryMetadataSettings.toString());
                    getSnapshotRepositoriesResponse.addSnapshotRepositoryMetadata(snapshotRepositoryDetails);
                });
            }
            catch (RepositoryMissingException repositoryMissingException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)repositoryMissingException, (Throwable)repositoryMissingException);
            }
        }
        return getSnapshotRepositoriesResponse;
    }

    protected GetRepositoriesRequestBuilder createGetRepositoriesRequestBuilder(GetSnapshotRepositoriesRequest getSnapshotRepositoriesRequest) {
        GetRepositoriesRequestBuilder getRepositoriesRequestBuilder = new GetRepositoriesRequestBuilder((ElasticsearchClient)this._elasticsearchClientResolver.getClient(false), GetRepositoriesAction.INSTANCE);
        getRepositoriesRequestBuilder.addRepositories(getSnapshotRepositoriesRequest.getRepositoryNames());
        return getRepositoriesRequestBuilder;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

