/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.SearchSearchRequestAssembler;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.SearchSearchRequestExecutor;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.SearchSearchResponseAssembler;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SearchSearchRequestExecutor.class})
public class SearchSearchRequestExecutorImpl
implements SearchSearchRequestExecutor {
    private static final Log _log = LogFactoryUtil.getLog(SearchSearchRequestExecutorImpl.class);
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    private SearchSearchRequestAssembler _searchSearchRequestAssembler;
    private SearchSearchResponseAssembler _searchSearchResponseAssembler;

    @Override
    public SearchSearchResponse execute(SearchSearchRequest searchSearchRequest) {
        SearchRequestBuilder searchRequestBuilder = new SearchRequestBuilder((ElasticsearchClient)this._elasticsearchClientResolver.getClient(searchSearchRequest.isPreferLocalCluster()), SearchAction.INSTANCE);
        this._searchSearchRequestAssembler.assemble(searchRequestBuilder, searchSearchRequest);
        if (_log.isTraceEnabled()) {
            String prettyPrintedRequestString = this._getPrettyPrintedRequestString(searchRequestBuilder);
            _log.trace((Object)("Search query: " + prettyPrintedRequestString));
        }
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.get();
        SearchSearchResponse searchSearchResponse = new SearchSearchResponse();
        this._searchSearchResponseAssembler.assemble(searchRequestBuilder, searchResponse, searchSearchRequest, searchSearchResponse);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"The search engine processed ", searchSearchResponse.getSearchRequestString(), " in ", searchSearchResponse.getExecutionTime(), " ms"}));
        }
        return searchSearchResponse;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }

    @Reference(unbind="-")
    protected void setSearchSearchRequestAssembler(SearchSearchRequestAssembler searchSearchRequestAssembler) {
        this._searchSearchRequestAssembler = searchSearchRequestAssembler;
    }

    @Reference(unbind="-")
    protected void setSearchSearchResponseAssembler(SearchSearchResponseAssembler searchSearchResponseAssembler) {
        this._searchSearchResponseAssembler = searchSearchResponseAssembler;
    }

    private String _getPrettyPrintedRequestString(SearchRequestBuilder searchRequestBuilder) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        JsonParser jsonParser = new JsonParser();
        try {
            return gson.toJson(jsonParser.parse(searchRequestBuilder.toString()));
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }
}

