/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.CommonSearchRequestBuilderAssembler;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.CommonSearchResponseAssembler;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.CountSearchRequestExecutor;
import com.liferay.portal.search.engine.adapter.search.BaseSearchRequest;
import com.liferay.portal.search.engine.adapter.search.BaseSearchResponse;
import com.liferay.portal.search.engine.adapter.search.CountSearchRequest;
import com.liferay.portal.search.engine.adapter.search.CountSearchResponse;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.search.SearchHits;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CountSearchRequestExecutor.class})
public class CountSearchRequestExecutorImpl
implements CountSearchRequestExecutor {
    private static final Log _log = LogFactoryUtil.getLog(CountSearchRequestExecutorImpl.class);
    private CommonSearchRequestBuilderAssembler _commonSearchRequestBuilderAssembler;
    private CommonSearchResponseAssembler _commonSearchResponseAssembler;
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public CountSearchResponse execute(CountSearchRequest countSearchRequest) {
        SearchRequestBuilder searchRequestBuilder = new SearchRequestBuilder((ElasticsearchClient)this._elasticsearchClientResolver.getClient(true), SearchAction.INSTANCE);
        this._commonSearchRequestBuilderAssembler.assemble(searchRequestBuilder, (BaseSearchRequest)countSearchRequest);
        searchRequestBuilder.setSize(0);
        searchRequestBuilder.setTrackScores(false);
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.get();
        SearchHits searchHits = searchResponse.getHits();
        CountSearchResponse countSearchResponse = new CountSearchResponse();
        TotalHits totalHits = searchHits.getTotalHits();
        countSearchResponse.setCount(totalHits.value);
        this._commonSearchResponseAssembler.assemble(searchRequestBuilder, searchResponse, (BaseSearchRequest)countSearchRequest, (BaseSearchResponse)countSearchResponse);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"The search engine processed ", countSearchResponse.getSearchRequestString(), " in ", countSearchResponse.getExecutionTime(), " ms"}));
        }
        return countSearchResponse;
    }

    @Reference(unbind="-")
    protected void setCommonSearchRequestBuilderAssembler(CommonSearchRequestBuilderAssembler commonSearchRequestBuilderAssembler) {
        this._commonSearchRequestBuilderAssembler = commonSearchRequestBuilderAssembler;
    }

    @Reference(unbind="-")
    protected void setCommonSearchResponseAssembler(CommonSearchResponseAssembler commonSearchResponseAssembler) {
        this._commonSearchResponseAssembler = commonSearchResponseAssembler;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

