/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index;

import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.IndicesOptionsTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.UpdateIndexSettingsIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.IndicesOptions;
import com.liferay.portal.search.engine.adapter.index.UpdateIndexSettingsIndexRequest;
import com.liferay.portal.search.engine.adapter.index.UpdateIndexSettingsIndexResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsAction;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequestBuilder;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={UpdateIndexSettingsIndexRequestExecutor.class})
public class UpdateIndexSettingsIndexRequestExecutorImpl
implements UpdateIndexSettingsIndexRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    private IndicesOptionsTranslator _indicesOptionsTranslator;

    @Override
    public UpdateIndexSettingsIndexResponse execute(UpdateIndexSettingsIndexRequest updateIndexSettingsIndexRequest) {
        UpdateSettingsRequestBuilder updateSettingsRequestBuilder = this.createUpdateSettingsRequestBuilder(updateIndexSettingsIndexRequest);
        AcknowledgedResponse acknowledgedResponse = (AcknowledgedResponse)updateSettingsRequestBuilder.get();
        return new UpdateIndexSettingsIndexResponse(acknowledgedResponse.isAcknowledged());
    }

    protected UpdateSettingsRequestBuilder createUpdateSettingsRequestBuilder(UpdateIndexSettingsIndexRequest updateIndexSettingsIndexRequest) {
        UpdateSettingsRequestBuilder updateSettingsRequestBuilder = new UpdateSettingsRequestBuilder((ElasticsearchClient)this._elasticsearchClientResolver.getClient(false), UpdateSettingsAction.INSTANCE, new String[0]);
        updateSettingsRequestBuilder.setIndices(updateIndexSettingsIndexRequest.getIndexNames());
        updateSettingsRequestBuilder.setSettings(updateIndexSettingsIndexRequest.getSettings(), XContentType.JSON);
        IndicesOptions indicesOptions = updateIndexSettingsIndexRequest.getIndicesOptions();
        if (indicesOptions != null) {
            updateSettingsRequestBuilder.setIndicesOptions(this._indicesOptionsTranslator.translate(indicesOptions));
        }
        return updateSettingsRequestBuilder;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }

    @Reference(unbind="-")
    protected void setIndicesOptionsTranslator(IndicesOptionsTranslator indicesOptionsTranslator) {
        this._indicesOptionsTranslator = indicesOptionsTranslator;
    }
}

