/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document;

import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document.ElasticsearchBulkableDocumentRequestTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document.IndexDocumentRequestExecutor;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.rest.RestStatus;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={IndexDocumentRequestExecutor.class})
public class IndexDocumentRequestExecutorImpl
implements IndexDocumentRequestExecutor {
    private ElasticsearchBulkableDocumentRequestTranslator _bulkableDocumentRequestTranslator;

    @Override
    public IndexDocumentResponse execute(IndexDocumentRequest indexDocumentRequest) {
        IndexRequestBuilder indexRequestBuilder = this._bulkableDocumentRequestTranslator.translate(indexDocumentRequest);
        IndexResponse indexResponse = (IndexResponse)indexRequestBuilder.get();
        RestStatus restStatus = indexResponse.status();
        return new IndexDocumentResponse(restStatus.getStatus(), indexResponse.getId());
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    protected void setBulkableDocumentRequestTranslator(ElasticsearchBulkableDocumentRequestTranslator eulkableDocumentRequestTranslator) {
        this._bulkableDocumentRequestTranslator = eulkableDocumentRequestTranslator;
    }
}

