/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document;

import com.liferay.portal.search.document.DocumentBuilder;
import com.liferay.portal.search.document.DocumentBuilderFactory;
import com.liferay.portal.search.elasticsearch7.internal.document.DocumentFieldsTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document.ElasticsearchBulkableDocumentRequestTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document.GetDocumentRequestExecutor;
import com.liferay.portal.search.engine.adapter.document.GetDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.GetDocumentResponse;
import com.liferay.portal.search.geolocation.GeoBuilders;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={GetDocumentRequestExecutor.class})
public class GetDocumentRequestExecutorImpl
implements GetDocumentRequestExecutor {
    private ElasticsearchBulkableDocumentRequestTranslator _bulkableDocumentRequestTranslator;
    private DocumentBuilderFactory _documentBuilderFactory;
    private GeoBuilders _geoBuilders;

    @Override
    public GetDocumentResponse execute(GetDocumentRequest getDocumentRequest) {
        GetRequestBuilder getRequestBuilder = this._bulkableDocumentRequestTranslator.translate(getDocumentRequest);
        GetResponse getResponse = (GetResponse)getRequestBuilder.get();
        GetDocumentResponse getDocumentResponse = new GetDocumentResponse(getResponse.isExists());
        if (!getResponse.isExists()) {
            return getDocumentResponse;
        }
        getDocumentResponse.setSource(getResponse.getSourceAsString());
        getDocumentResponse.setVersion(getResponse.getVersion());
        DocumentFieldsTranslator documentFieldsTranslator = new DocumentFieldsTranslator(this._geoBuilders);
        DocumentBuilder documentBuilder = this._documentBuilderFactory.builder();
        documentFieldsTranslator.translate(documentBuilder, getResponse.getSourceAsMap());
        getDocumentResponse.setDocument(documentBuilder.build());
        return getDocumentResponse;
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    protected void setBulkableDocumentRequestTranslator(ElasticsearchBulkableDocumentRequestTranslator eulkableDocumentRequestTranslator) {
        this._bulkableDocumentRequestTranslator = eulkableDocumentRequestTranslator;
    }

    @Reference(unbind="-")
    protected void setDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        this._documentBuilderFactory = documentBuilderFactory;
    }

    @Reference(unbind="-")
    protected void setGeoBuilders(GeoBuilders geoBuilders) {
        this._geoBuilders = geoBuilders;
    }
}

