/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document;

import com.liferay.portal.kernel.search.query.QueryTranslator;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document.DeleteByQueryDocumentRequestExecutor;
import com.liferay.portal.search.engine.adapter.document.DeleteByQueryDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DeleteByQueryDocumentResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequestBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DeleteByQueryDocumentRequestExecutor.class})
public class DeleteByQueryDocumentRequestExecutorImpl
implements DeleteByQueryDocumentRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    private QueryTranslator<QueryBuilder> _queryTranslator;

    @Override
    public DeleteByQueryDocumentResponse execute(DeleteByQueryDocumentRequest deleteByQueryDocumentRequest) {
        DeleteByQueryRequestBuilder deleteByQueryRequestBuilder = this.createDeleteByQueryRequestBuilder(deleteByQueryDocumentRequest);
        BulkByScrollResponse bulkByScrollResponse = (BulkByScrollResponse)deleteByQueryRequestBuilder.get();
        TimeValue timeValue = bulkByScrollResponse.getTook();
        return new DeleteByQueryDocumentResponse(bulkByScrollResponse.getDeleted(), timeValue.getMillis());
    }

    protected DeleteByQueryRequestBuilder createDeleteByQueryRequestBuilder(DeleteByQueryDocumentRequest deleteByQueryDocumentRequest) {
        DeleteByQueryRequestBuilder deleteByQueryRequestBuilder = new DeleteByQueryRequestBuilder((ElasticsearchClient)this._elasticsearchClientResolver.getClient(false), (ActionType)DeleteByQueryAction.INSTANCE);
        QueryBuilder queryBuilder = (QueryBuilder)this._queryTranslator.translate(deleteByQueryDocumentRequest.getQuery(), null);
        deleteByQueryRequestBuilder.filter(queryBuilder);
        deleteByQueryRequestBuilder.refresh(deleteByQueryDocumentRequest.isRefresh());
        deleteByQueryRequestBuilder.source(deleteByQueryDocumentRequest.getIndexNames());
        return deleteByQueryRequestBuilder;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    protected void setQueryTranslator(QueryTranslator<QueryBuilder> queryTranslator) {
        this._queryTranslator = queryTranslator;
    }
}

