/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.cluster;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.cluster.ClusterHealthStatusTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.cluster.StatsClusterRequestExecutor;
import com.liferay.portal.search.engine.adapter.cluster.StatsClusterRequest;
import com.liferay.portal.search.engine.adapter.cluster.StatsClusterResponse;
import java.io.IOException;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsAction;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsRequestBuilder;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StatsClusterRequestExecutor.class})
public class StatsClusterRequestExecutorImpl
implements StatsClusterRequestExecutor {
    private ClusterHealthStatusTranslator _clusterHealthStatusTranslator;
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public StatsClusterResponse execute(StatsClusterRequest statsClusterRequest) {
        ClusterStatsRequestBuilder clusterStatsRequestBuilder = this.createClusterStatsRequestBuilder(statsClusterRequest);
        ClusterStatsResponse clusterStatsResponse = (ClusterStatsResponse)clusterStatsRequestBuilder.get();
        try {
            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
            xContentBuilder.startObject();
            xContentBuilder = clusterStatsResponse.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
            xContentBuilder.endObject();
            ClusterHealthStatus clusterHealthStatus = clusterStatsResponse.getStatus();
            return new StatsClusterResponse(this._clusterHealthStatusTranslator.translate(clusterHealthStatus), Strings.toString((XContentBuilder)xContentBuilder));
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    protected ClusterStatsRequestBuilder createClusterStatsRequestBuilder(StatsClusterRequest statsClusterRequest) {
        return new ClusterStatsRequestBuilder((ElasticsearchClient)this._elasticsearchClientResolver.getClient(true), ClusterStatsAction.INSTANCE);
    }

    @Reference(unbind="-")
    protected void setClusterHealthStatusTranslator(ClusterHealthStatusTranslator clusterHealthStatusTranslator) {
        this._clusterHealthStatusTranslator = clusterHealthStatusTranslator;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

