/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.cluster;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.cluster.ClusterHealthStatusTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.cluster.HealthClusterRequestExecutor;
import com.liferay.portal.search.engine.adapter.cluster.HealthClusterRequest;
import com.liferay.portal.search.engine.adapter.cluster.HealthClusterResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthAction;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.unit.TimeValue;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={HealthClusterRequestExecutor.class})
public class HealthClusterRequestExecutorImpl
implements HealthClusterRequestExecutor {
    private ClusterHealthStatusTranslator _clusterHealthStatusTranslator;
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public HealthClusterResponse execute(HealthClusterRequest healthClusterRequest) {
        ClusterHealthRequestBuilder clusterHealthRequestBuilder = this.createClusterHealthRequestBuilder(healthClusterRequest);
        ClusterHealthResponse clusterHealthResponse = (ClusterHealthResponse)clusterHealthRequestBuilder.get();
        ClusterHealthStatus clusterHealthStatus = clusterHealthResponse.getStatus();
        return new HealthClusterResponse(this._clusterHealthStatusTranslator.translate(clusterHealthStatus), clusterHealthResponse.toString());
    }

    protected ClusterHealthRequestBuilder createClusterHealthRequestBuilder(HealthClusterRequest healthClusterRequest) {
        long timeout;
        ClusterHealthRequestBuilder clusterHealthRequestBuilder = new ClusterHealthRequestBuilder((ElasticsearchClient)this._elasticsearchClientResolver.getClient(true), ClusterHealthAction.INSTANCE);
        if (ArrayUtil.isNotEmpty((Object[])healthClusterRequest.getIndexNames())) {
            clusterHealthRequestBuilder.setIndices(healthClusterRequest.getIndexNames());
        }
        if ((timeout = healthClusterRequest.getTimeout()) > 0L) {
            clusterHealthRequestBuilder.setMasterNodeTimeout(TimeValue.timeValueMillis((long)timeout));
            clusterHealthRequestBuilder.setTimeout(TimeValue.timeValueMillis((long)timeout));
        }
        if (healthClusterRequest.getWaitForClusterHealthStatus() != null) {
            clusterHealthRequestBuilder.setWaitForStatus(this._clusterHealthStatusTranslator.translate(healthClusterRequest.getWaitForClusterHealthStatus()));
        }
        return clusterHealthRequestBuilder;
    }

    @Reference(unbind="-")
    protected void setClusterHealthStatusTranslator(ClusterHealthStatusTranslator clusterHealthStatusTranslator) {
        this._clusterHealthStatusTranslator = clusterHealthStatusTranslator;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

