/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.query;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.search.elasticsearch7.internal.geolocation.ElasticsearchShapeTranslator;
import com.liferay.portal.search.elasticsearch7.internal.query.GeoShapeQueryTranslator;
import com.liferay.portal.search.geolocation.Shape;
import com.liferay.portal.search.geolocation.ShapeTranslator;
import com.liferay.portal.search.query.GeoShapeQuery;
import java.io.IOException;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.SpatialStrategy;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.osgi.service.component.annotations.Component;

@Component(service={GeoShapeQueryTranslator.class})
public class GeoShapeQueryTranslatorImpl
implements GeoShapeQueryTranslator {
    private final ElasticsearchShapeTranslator _elasticsearchShapeTranslator = new ElasticsearchShapeTranslator();

    @Override
    public QueryBuilder translate(GeoShapeQuery geoShapeQuery) {
        GeoShapeQueryBuilder geoShapeQueryBuilder = this.translateQuery(geoShapeQuery);
        if (geoShapeQuery.getIgnoreUnmapped() != null) {
            geoShapeQueryBuilder.ignoreUnmapped(geoShapeQuery.getIgnoreUnmapped().booleanValue());
        }
        if (geoShapeQuery.getShapeRelation() != null) {
            geoShapeQueryBuilder.relation(this.translate(geoShapeQuery.getShapeRelation()));
        }
        if (geoShapeQuery.getSpatialStrategy() != null) {
            geoShapeQueryBuilder.strategy(this.translate(geoShapeQuery.getSpatialStrategy()));
        }
        return geoShapeQueryBuilder;
    }

    protected ShapeRelation translate(com.liferay.portal.search.query.geolocation.ShapeRelation shapeRelation) {
        if (shapeRelation == com.liferay.portal.search.query.geolocation.ShapeRelation.CONTAINS) {
            return ShapeRelation.CONTAINS;
        }
        if (shapeRelation == com.liferay.portal.search.query.geolocation.ShapeRelation.DISJOINT) {
            return ShapeRelation.DISJOINT;
        }
        if (shapeRelation == com.liferay.portal.search.query.geolocation.ShapeRelation.INTERSECTS) {
            return ShapeRelation.INTERSECTS;
        }
        if (shapeRelation == com.liferay.portal.search.query.geolocation.ShapeRelation.WITHIN) {
            return ShapeRelation.WITHIN;
        }
        throw new IllegalArgumentException("Invalid ShapeRelation: " + shapeRelation);
    }

    protected SpatialStrategy translate(com.liferay.portal.search.query.geolocation.SpatialStrategy spatialStrategy) {
        if (spatialStrategy == com.liferay.portal.search.query.geolocation.SpatialStrategy.RECURSIVE) {
            return SpatialStrategy.RECURSIVE;
        }
        if (spatialStrategy == com.liferay.portal.search.query.geolocation.SpatialStrategy.TERM) {
            return SpatialStrategy.TERM;
        }
        throw new IllegalArgumentException("Invalid SpatialStrategy: " + spatialStrategy);
    }

    protected GeoShapeQueryBuilder translateQuery(GeoShapeQuery geoShapeQuery) {
        if (geoShapeQuery.getIndexedShapeId() != null) {
            GeoShapeQueryBuilder geoShapeQueryBuilder = QueryBuilders.geoShapeQuery((String)geoShapeQuery.getField(), (String)geoShapeQuery.getIndexedShapeId(), (String)geoShapeQuery.getIndexedShapeType());
            if (geoShapeQuery.getIndexedShapeIndex() != null) {
                geoShapeQueryBuilder.indexedShapeIndex(geoShapeQuery.getIndexedShapeIndex());
            }
            if (geoShapeQuery.getIndexedShapePath() != null) {
                geoShapeQueryBuilder.indexedShapePath(geoShapeQuery.getIndexedShapePath());
            }
            if (geoShapeQuery.getIndexedShapeRouting() != null) {
                geoShapeQueryBuilder.indexedShapeRouting(geoShapeQuery.getIndexedShapeRouting());
            }
            return geoShapeQueryBuilder;
        }
        try {
            Shape shape = geoShapeQuery.getShape();
            return QueryBuilders.geoShapeQuery((String)geoShapeQuery.getField(), (ShapeBuilder)((ShapeBuilder)shape.accept((ShapeTranslator)this._elasticsearchShapeTranslator)));
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }
}

