/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.facet;

import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.FilterTranslator;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.search.elasticsearch7.internal.facet.AggregationFilteringFacetProcessorContext;
import com.liferay.portal.search.elasticsearch7.internal.facet.CompositeFacetProcessor;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetProcessor;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetProcessorContext;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FacetTranslator.class})
public class DefaultFacetTranslator
implements FacetTranslator {
    private FacetProcessor<SearchRequestBuilder> _facetProcessor;
    private FilterTranslator<QueryBuilder> _filterTranslator;

    @Override
    public void translate(SearchRequestBuilder searchRequestBuilder, Query query, Map<String, Facet> facetsMap, boolean basicFacetSelection) {
        if (MapUtil.isEmpty(facetsMap)) {
            return;
        }
        Collection<Facet> facets = facetsMap.values();
        FacetProcessorContext facetProcessorContext = this.getFacetProcessorContext(facets, basicFacetSelection);
        ArrayList<QueryBuilder> postFilterQueryBuilders = new ArrayList<QueryBuilder>();
        if (query != null && query.getPostFilter() != null) {
            postFilterQueryBuilders.add((QueryBuilder)this._filterTranslator.translate(query.getPostFilter(), null));
        }
        for (Facet facet : facets) {
            if (facet.isStatic()) continue;
            Optional<QueryBuilder> postFilterQueryBuilderOptional = this.translateFacetQuery(facet);
            postFilterQueryBuilderOptional.ifPresent(postFilterQueryBuilders::add);
            Optional<AggregationBuilder> optional = this._facetProcessor.processFacet(facet);
            optional.map(aggregationBuilder -> this.postProcessAggregationBuilder((AggregationBuilder)aggregationBuilder, facetProcessorContext)).ifPresent(arg_0 -> ((SearchRequestBuilder)searchRequestBuilder).addAggregation(arg_0));
        }
        if (!ListUtil.isEmpty(postFilterQueryBuilders)) {
            searchRequestBuilder.setPostFilter(this.getPostFilter(postFilterQueryBuilders));
        }
    }

    protected FacetProcessorContext getFacetProcessorContext(Collection<Facet> facets, boolean basicFacetSelection) {
        if (basicFacetSelection) {
            return null;
        }
        return AggregationFilteringFacetProcessorContext.newInstance(facets);
    }

    protected QueryBuilder getPostFilter(List<QueryBuilder> queryBuilders) {
        if (queryBuilders.size() == 1) {
            return queryBuilders.get(0);
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        for (QueryBuilder queryBuilder : queryBuilders) {
            boolQueryBuilder.must(queryBuilder);
        }
        return boolQueryBuilder;
    }

    protected AggregationBuilder postProcessAggregationBuilder(AggregationBuilder aggregationBuilder, FacetProcessorContext facetProcessorContext) {
        if (facetProcessorContext != null) {
            return facetProcessorContext.postProcessAggregationBuilder(aggregationBuilder);
        }
        return aggregationBuilder;
    }

    @Reference(service=CompositeFacetProcessor.class, unbind="-")
    protected void setFacetProcessor(FacetProcessor<SearchRequestBuilder> facetProcessor) {
        this._facetProcessor = facetProcessor;
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    protected void setFilterTranslator(FilterTranslator<QueryBuilder> filterTranslator) {
        this._filterTranslator = filterTranslator;
    }

    protected QueryBuilder translateBooleanClause(BooleanClause<Filter> booleanClause) {
        BooleanFilter booleanFilter = new BooleanFilter();
        booleanFilter.add((Filter)booleanClause.getClause(), booleanClause.getBooleanClauseOccur());
        return (QueryBuilder)this._filterTranslator.translate((Filter)booleanFilter, null);
    }

    protected Optional<QueryBuilder> translateFacetQuery(Facet facet) {
        BooleanClause booleanClause = facet.getFacetFilterBooleanClause();
        if (booleanClause == null) {
            return Optional.empty();
        }
        QueryBuilder queryBuilder = this.translateBooleanClause((BooleanClause<Filter>)booleanClause);
        return Optional.of(queryBuilder);
    }
}

